/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.context;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.OptimizableBinding;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.assembly.CompositeActivator;
import org.apache.tuscany.sca.core.context.ComponentContextImpl;
import org.apache.tuscany.sca.core.invocation.ThreadMessageContext;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContextHelper {
    private final AssemblyFactory assemblyFactory;
    private final JavaInterfaceFactory javaInterfaceFactory;
    private final StAXArtifactProcessorExtensionPoint staxProcessors;

    public ComponentContextHelper(AssemblyFactory assemblyFactory, JavaInterfaceFactory javaInterfaceFactory, StAXArtifactProcessorExtensionPoint processors) {
        this.assemblyFactory = assemblyFactory;
        this.javaInterfaceFactory = javaInterfaceFactory;
        this.staxProcessors = processors;
    }

    public ComponentReference createSelfReference(Component component, ComponentService service, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        ComponentReference componentReference = this.assemblyFactory.createComponentReference();
        componentReference.setName("$self$." + service.getName());
        for (Binding binding : service.getBindings()) {
            if (binding instanceof OptimizableBinding) {
                OptimizableBinding optimizableBinding = (OptimizableBinding)((OptimizableBinding)binding).clone();
                optimizableBinding.setTargetBinding(binding);
                optimizableBinding.setTargetComponent(component);
                optimizableBinding.setTargetComponentService(service);
                componentReference.getBindings().add(optimizableBinding);
                continue;
            }
            componentReference.getBindings().add(binding);
        }
        componentReference.setCallback(service.getCallback());
        componentReference.getTargets().add(service);
        componentReference.getPolicySets().addAll(service.getPolicySets());
        componentReference.getRequiredIntents().addAll(service.getRequiredIntents());
        InterfaceContract interfaceContract = service.getInterfaceContract();
        Service componentTypeService = service.getService();
        if (componentTypeService != null && componentTypeService.getInterfaceContract() != null) {
            interfaceContract = componentTypeService.getInterfaceContract();
        }
        interfaceContract = this.getInterfaceContract(interfaceContract, businessInterface);
        componentReference.setInterfaceContract(interfaceContract);
        componentReference.setMultiplicity(Multiplicity.ONE_ONE);
        return componentReference;
    }

    private InterfaceContract getInterfaceContract(InterfaceContract interfaceContract, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Class<?> cls;
        Interface interfaze = interfaceContract.getInterface();
        boolean compatible = false;
        if (interfaze instanceof JavaInterface && businessInterface.isAssignableFrom(cls = ((JavaInterface)interfaze).getJavaClass())) {
            compatible = true;
        }
        if (!compatible) {
            interfaceContract = (InterfaceContract)interfaceContract.clone();
            interfaceContract.setInterface(this.javaInterfaceFactory.createJavaInterface(businessInterface));
        }
        return interfaceContract;
    }

    public RuntimeComponentReference bindComponentReference(Class<?> businessInterface, RuntimeComponentReference reference, RuntimeComponent component, RuntimeComponentService service) throws CloneNotSupportedException, InvalidInterfaceException {
        InterfaceContract refInterfaceContract;
        RuntimeComponentReference ref = (RuntimeComponentReference)reference.clone();
        InterfaceContract interfaceContract = reference.getInterfaceContract();
        Reference componentTypeReference = reference.getReference();
        if (componentTypeReference != null && componentTypeReference.getInterfaceContract() != null) {
            interfaceContract = componentTypeReference.getInterfaceContract();
        }
        if ((refInterfaceContract = this.getInterfaceContract(interfaceContract, businessInterface)) != interfaceContract) {
            ref = (RuntimeComponentReference)reference.clone();
            ref.setInterfaceContract(interfaceContract);
        }
        ref.setComponent(component);
        ref.getTargets().add(service);
        ref.getBindings().clear();
        for (Binding binding : service.getBindings()) {
            if (binding instanceof OptimizableBinding) {
                OptimizableBinding optimizableBinding = (OptimizableBinding)((OptimizableBinding)binding).clone();
                optimizableBinding.setTargetBinding(binding);
                optimizableBinding.setTargetComponent(component);
                optimizableBinding.setTargetComponentService(service);
                ref.getBindings().add(optimizableBinding);
                continue;
            }
            ref.getBindings().add(binding);
        }
        return ref;
    }

    public void write(Component component, ComponentReference reference, Writer writer) throws IOException {
        this.write(component, reference, null, writer);
    }

    public void write(Component component, ComponentReference reference, ComponentService service, Writer writer) throws IOException {
        try {
            StAXArtifactProcessor processor = (StAXArtifactProcessor)this.staxProcessors.getProcessor(Composite.class);
            Composite composite = this.assemblyFactory.createComposite();
            composite.setName(new QName("http://tuscany.apache.org/xmlns/sca/1.0", "default"));
            Component comp = this.assemblyFactory.createComponent();
            comp.setName("default");
            comp.setURI(component.getURI());
            composite.getComponents().add(comp);
            if (reference != null) {
                comp.getReferences().add(reference);
            }
            if (service != null) {
                comp.getServices().add(service);
            }
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter streamWriter = outputFactory.createXMLStreamWriter(writer);
            processor.write(composite, streamWriter);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public String toXML(Component component, ComponentReference reference) throws IOException {
        StringWriter writer = new StringWriter();
        this.write(component, reference, writer);
        return writer.toString();
    }

    public String toXML(Component component, ComponentService service) throws IOException {
        StringWriter writer = new StringWriter();
        this.write(component, null, service, writer);
        return writer.toString();
    }

    public RuntimeComponent read(Reader reader) throws IOException {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLStreamReader streamReader = inputFactory.createXMLStreamReader(reader);
            return this.read(streamReader);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public RuntimeComponent read(XMLStreamReader streamReader) throws IOException {
        try {
            StAXArtifactProcessor processor = (StAXArtifactProcessor)this.staxProcessors.getProcessor(Composite.class);
            Composite composite = (Composite)processor.read(streamReader);
            RuntimeComponent component = (RuntimeComponent)composite.getComponents().get(0);
            return component;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public Component fromXML(String xml) throws IOException {
        return this.read(new StringReader(xml));
    }

    public Component fromXML(XMLStreamReader streamReader) throws IOException {
        return this.read(streamReader);
    }

    public static RuntimeComponent getCurrentComponent() {
        Message message = ThreadMessageContext.getMessageContext();
        if (message != null) {
            EndpointReference to = message.getTo();
            if (to == null) {
                return null;
            }
            RuntimeComponent component = message.getTo().getComponent();
            return component;
        }
        return null;
    }

    public static CompositeActivator getCurrentCompositeActivator() {
        RuntimeComponent component = ComponentContextHelper.getCurrentComponent();
        if (component != null) {
            ComponentContextImpl context = (ComponentContextImpl)component.getComponentContext();
            return context.getCompositeActivator();
        }
        return null;
    }

    public static ComponentContextHelper getCurrentComponentContextHelper() {
        CompositeActivator activator = ComponentContextHelper.getCurrentCompositeActivator();
        if (activator != null) {
            return activator.getComponentContextHelper();
        }
        return null;
    }

    public static ComponentService getSingleService(Component component) {
        List<ComponentService> services = component.getServices();
        ArrayList<ComponentService> regularServices = new ArrayList<ComponentService>();
        for (ComponentService service : services) {
            String name;
            if (service.isCallback() || (name = service.getName()).startsWith("$") && !name.startsWith("$dynamic$")) continue;
            regularServices.add(service);
        }
        if (regularServices.size() == 0) {
            throw new ServiceRuntimeException("No service is declared on component " + component.getURI());
        }
        if (regularServices.size() != 1) {
            throw new ServiceRuntimeException("More than one service is declared on component " + component.getURI() + ". Service name is required to get the service.");
        }
        ComponentService targetService = (ComponentService)regularServices.get(0);
        return targetService;
    }
}

