/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.context;

import java.util.List;
import javax.security.auth.Subject;
import org.apache.tuscany.sca.core.context.CallableReferenceImpl;
import org.apache.tuscany.sca.core.invocation.CallbackReferenceImpl;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ThreadMessageContext;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.CallableReference;
import org.osoa.sca.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestContextImpl
implements RequestContext {
    private ProxyFactory proxyFactory;

    public RequestContextImpl(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    public Subject getSecuritySubject() {
        Subject subject = null;
        for (Object header : ThreadMessageContext.getMessageContext().getHeaders()) {
            if (!(header instanceof Subject)) continue;
            subject = (Subject)header;
            break;
        }
        return subject;
    }

    @Override
    public String getServiceName() {
        return ThreadMessageContext.getMessageContext().getTo().getContract().getName();
    }

    @Override
    public <B> CallableReference<B> getServiceReference() {
        Message msgContext = ThreadMessageContext.getMessageContext();
        EndpointReference to = msgContext.getTo();
        RuntimeComponentService service = (RuntimeComponentService)to.getContract();
        RuntimeComponent component = to.getComponent();
        CallableReference callableReference = component.getComponentContext().getCallableReference(null, component, service);
        ReferenceParameters parameters = msgContext.getFrom().getReferenceParameters();
        ((CallableReferenceImpl)callableReference).attachCallbackID(parameters.getCallbackID());
        ((CallableReferenceImpl)callableReference).attachConversation(parameters.getConversationID());
        return callableReference;
    }

    @Override
    public <CB> CB getCallback() {
        CallableReference<CB> cb = this.getCallbackReference();
        if (cb == null) {
            return null;
        }
        return cb.getService();
    }

    @Override
    public <CB> CallableReference<CB> getCallbackReference() {
        List<RuntimeWire> wires;
        Message msgContext = ThreadMessageContext.getMessageContext();
        EndpointReference to = msgContext.getTo();
        RuntimeComponentService service = (RuntimeComponentService)to.getContract();
        RuntimeComponentReference callbackReference = (RuntimeComponentReference)service.getCallbackReference();
        if (callbackReference == null) {
            return null;
        }
        JavaInterface javaInterface = (JavaInterface)callbackReference.getInterfaceContract().getInterface();
        Class<?> javaClass = javaInterface.getJavaClass();
        CallbackReferenceImpl ref = CallbackReferenceImpl.newInstance(javaClass, this.proxyFactory, wires = callbackReference.getRuntimeWires());
        if (ref != null) {
            ReferenceParameters parameters = msgContext.getFrom().getReferenceParameters();
            ref.attachCallbackID(parameters.getCallbackID());
            if (ref.getConversation() != null) {
                ref.attachConversationID(parameters.getConversationID());
            }
        }
        return ref;
    }
}

