/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.conversation;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.tuscany.sca.core.conversation.ConversationListener;
import org.apache.tuscany.sca.core.conversation.ConversationManager;
import org.apache.tuscany.sca.core.conversation.ConversationState;
import org.apache.tuscany.sca.core.conversation.ExtendedConversation;
import org.apache.tuscany.sca.core.conversation.ExtendedConversationImpl;

public class ConversationManagerImpl
implements ConversationManager {
    private List<ConversationListener> listeners = Collections.synchronizedList(new ArrayList());
    private Map<Object, ExtendedConversation> conversations = new ConcurrentHashMap<Object, ExtendedConversation>();
    private static final long DEFAULT_MAX_AGE = 3600000L;
    private static final long DEFAULT_MAX_IDLE_TIME = 3600000L;
    private final long maxAge;
    private final long maxIdleTime;
    private final ScheduledExecutorService scheduler;

    public ConversationManagerImpl() {
        long mit = 3600000L;
        long ma = 3600000L;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        String aProperty = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("org.apache.tuscany.sca.core.scope.ConversationalScopeContainer.MaxIdleTime");
            }
        });
        if (aProperty != null) {
            try {
                mit = new Long(aProperty) * 1000L;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((aProperty = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("org.apache.tuscany.sca.core.scope.ConversationalScopeContainer.MaxAge");
            }
        })) != null) {
            try {
                ma = new Long(aProperty) * 1000L;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.maxAge = ma;
        this.maxIdleTime = mit;
    }

    public void addListener(ConversationListener listener) {
        this.listeners.add(listener);
    }

    public void endConversation(Object conversationID) {
        ExtendedConversation conv = this.getConversation(conversationID);
        if (conv != null) {
            conv.setState(ConversationState.ENDED);
            for (ConversationListener listener : this.listeners) {
                listener.conversationEnded(conv);
            }
        } else {
            throw new IllegalStateException("Conversation " + conversationID + " doesn't exist.");
        }
        conv.setConversationID(null);
        this.conversations.remove(conversationID);
    }

    public void expireConversation(Object conversationID) {
        ExtendedConversation conv = this.getConversation(conversationID);
        if (conv != null) {
            for (ConversationListener listener : this.listeners) {
                listener.conversationExpired(conv);
            }
        } else {
            throw new IllegalStateException("Conversation " + conversationID + " doesn't exist.");
        }
        this.conversations.remove(conversationID);
    }

    public ExtendedConversation getConversation(Object conversationID) {
        return conversationID == null ? null : this.conversations.get(conversationID);
    }

    public void removeListener(ConversationListener listener) {
        this.listeners.remove(listener);
    }

    public void scheduleConversation(ExtendedConversationImpl aConversation, long time) {
        this.scheduler.schedule(aConversation, time, TimeUnit.MILLISECONDS);
    }

    public synchronized void stopReaper() {
        this.scheduler.shutdown();
    }

    public ExtendedConversation startConversation(Object conversationID) {
        ExtendedConversation conversation;
        if (conversationID == null) {
            conversationID = UUID.randomUUID().toString();
        }
        if ((conversation = this.getConversation(conversationID)) != null && conversation.getState() != ConversationState.ENDED) {
            throw new IllegalStateException(conversation + " already exists.");
        }
        conversation = new ExtendedConversationImpl(this, conversationID, ConversationState.STARTED);
        this.conversations.put(conversationID, conversation);
        for (ConversationListener listener : this.listeners) {
            listener.conversationStarted(conversation);
        }
        return conversation;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void destroy() {
        this.scheduler.shutdownNow();
        this.listeners.clear();
        this.conversations.clear();
    }
}

