/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.conversation;

import org.apache.tuscany.sca.core.conversation.ConversationManagerImpl;
import org.apache.tuscany.sca.core.conversation.ConversationState;
import org.apache.tuscany.sca.core.conversation.ExtendedConversation;
import org.apache.tuscany.sca.core.scope.ScopedImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class ExtendedConversationImpl
implements ExtendedConversation,
Runnable {
    private final ConversationManagerImpl manager;
    private volatile Object conversationID;
    private ConversationState state;
    private final Object stateSync = new Object();
    private long expirationTime = 0L;
    private long maxIdleTime = 0L;
    private long maxAge = 0L;
    private long creationTime;
    private long lastReferencedTime = this.creationTime = System.currentTimeMillis();
    private boolean expired = false;
    private boolean conversationAttributesInitialized = false;

    public ExtendedConversationImpl(ConversationManagerImpl manager, Object conversationID, ConversationState state) {
        this.manager = manager;
        this.conversationID = conversationID;
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        long currentTime;
        Object object = this.stateSync;
        synchronized (object) {
            if (!this.conversationAttributesInitialized) {
                return false;
            }
            if (this.state == ConversationState.EXPIRED) {
                return true;
            }
            currentTime = System.currentTimeMillis();
            if (this.lastReferencedTime + this.maxIdleTime <= currentTime || this.expirationTime <= currentTime) {
                this.setState(ConversationState.EXPIRED);
                return true;
            }
        }
        this.scheduleNextExpiryTime(currentTime);
        return false;
    }

    public void scheduleNextExpiryTime(long currentTime) {
        if (this.lastReferencedTime + this.maxIdleTime < this.expirationTime) {
            this.manager.scheduleConversation(this, this.lastReferencedTime + this.maxIdleTime - currentTime);
        } else {
            this.manager.scheduleConversation(this, this.expirationTime - currentTime);
        }
    }

    public void updateLastReferencedTime() {
        this.lastReferencedTime = System.currentTimeMillis();
        if (this.conversationAttributesInitialized) {
            this.scheduleNextExpiryTime(this.lastReferencedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationState getState() {
        Object object = this.stateSync;
        synchronized (object) {
            return this.state;
        }
    }

    public void end() {
        this.manager.endConversation(this.conversationID);
    }

    public Object getConversationID() {
        return this.conversationID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(ConversationState state) {
        Object object = this.stateSync;
        synchronized (object) {
            this.state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConversationID(Object conversationID) {
        Object object = this.stateSync;
        synchronized (object) {
            if (this.state != ConversationState.ENDED) {
                throw new IllegalStateException("The state of conversation " + conversationID + " " + (Object)((Object)this.state));
            }
        }
        this.conversationID = conversationID;
    }

    public void initializeConversationAttributes(RuntimeComponent targetComponent) {
        if (targetComponent != null) {
            this.maxAge = this.getMaxIdleTime(targetComponent.getImplementationProvider());
            this.maxIdleTime = this.getMaxAge(targetComponent.getImplementationProvider());
            this.expirationTime = this.creationTime + this.maxAge;
            this.conversationAttributesInitialized = true;
        }
    }

    public boolean conversationalAttributesInitialized() {
        return this.conversationAttributesInitialized;
    }

    private long getMaxIdleTime(ImplementationProvider impProvider) {
        ScopedImplementationProvider aScopedImpl;
        long maxIdleTime;
        if (impProvider != null && impProvider instanceof ScopedImplementationProvider && (maxIdleTime = (aScopedImpl = (ScopedImplementationProvider)impProvider).getMaxIdleTime()) > 0L) {
            return maxIdleTime;
        }
        return this.manager.getMaxIdleTime();
    }

    private long getMaxAge(ImplementationProvider impProvider) {
        ScopedImplementationProvider aScopedImpl;
        long maxAge;
        if (impProvider != null && impProvider instanceof ScopedImplementationProvider && (maxAge = (aScopedImpl = (ScopedImplementationProvider)impProvider).getMaxAge()) > 0L) {
            return maxAge;
        }
        return this.manager.getMaxAge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.stateSync;
        synchronized (object) {
            if (!this.expired && this.isExpired()) {
                this.expired = true;
                try {
                    this.manager.expireConversation(this.getConversationID());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }
}

