/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.annotation.DataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBindingJavaInterfaceProcessor
implements JavaInterfaceVisitor {
    private DataBindingExtensionPoint dataBindingRegistry;

    public DataBindingJavaInterfaceProcessor(DataBindingExtensionPoint dataBindingRegistry) {
        this.dataBindingRegistry = dataBindingRegistry;
    }

    @Override
    public void visitInterface(JavaInterface javaInterface) throws InvalidInterfaceException {
        if (!javaInterface.isRemotable()) {
            return;
        }
        List<Operation> operations = javaInterface.getOperations();
        this.processInterface(javaInterface, operations);
    }

    private void processInterface(JavaInterface javaInterface, List<Operation> operations) {
        Class<?> clazz = javaInterface.getJavaClass();
        DataBinding dataBinding = clazz.getAnnotation(DataBinding.class);
        String dataBindingId = null;
        boolean wrapperStyle = false;
        if (dataBinding != null) {
            dataBindingId = dataBinding.value();
            wrapperStyle = dataBinding.wrapped();
        }
        HashMap<String, Operation> opMap = new HashMap<String, Operation>();
        for (Operation op : javaInterface.getOperations()) {
            opMap.put(op.getName(), op);
            if (op instanceof JavaOperation) {
                opMap.put(((JavaOperation)op).getJavaMethod().getName(), op);
            }
            if (dataBindingId == null) continue;
            op.setDataBinding(dataBindingId);
            op.setInputWrapperStyle(wrapperStyle);
            op.setOutputWrapperStyle(wrapperStyle);
        }
        for (Method method : clazz.getMethods()) {
            org.apache.tuscany.sca.databinding.annotation.DataType dt;
            Operation operation;
            if (method.getDeclaringClass() == Object.class || (operation = (Operation)opMap.get(method.getName())) == null) continue;
            DataBinding methodDataBinding = clazz.getAnnotation(DataBinding.class);
            if (methodDataBinding == null) {
                methodDataBinding = dataBinding;
            }
            dataBindingId = null;
            wrapperStyle = false;
            if (dataBinding != null) {
                dataBindingId = dataBinding.value();
                wrapperStyle = dataBinding.wrapped();
                operation.setDataBinding(dataBindingId);
                operation.setInputWrapperStyle(wrapperStyle);
                operation.setOutputWrapperStyle(wrapperStyle);
            }
            int i = 0;
            for (DataType d : operation.getInputType().getLogical()) {
                if (d.getDataBinding() == null) {
                    d.setDataBinding(dataBindingId);
                }
                for (Annotation a : method.getParameterAnnotations()[i]) {
                    if (a.annotationType() != org.apache.tuscany.sca.databinding.annotation.DataType.class) continue;
                    String value = ((org.apache.tuscany.sca.databinding.annotation.DataType)a).value();
                    d.setDataBinding(value);
                }
                this.dataBindingRegistry.introspectType(d, operation);
                ++i;
            }
            if (operation.getOutputType() == null) continue;
            DataType d = operation.getOutputType();
            if (d.getDataBinding() == null) {
                d.setDataBinding(dataBindingId);
            }
            if ((dt = method.getAnnotation(org.apache.tuscany.sca.databinding.annotation.DataType.class)) != null) {
                d.setDataBinding(dt.value());
            }
            this.dataBindingRegistry.introspectType(d, operation);
        }
    }
}

