/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.processor;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;

public class WrapperJavaInterfaceProcessor
implements JavaInterfaceVisitor {
    private static final String JAXB_DATABINDING = "javax.xml.bind.JAXBElement";
    private DataBindingExtensionPoint dataBindingRegistry;

    public WrapperJavaInterfaceProcessor(DataBindingExtensionPoint dataBindingRegistry) {
        this.dataBindingRegistry = dataBindingRegistry;
    }

    public void visitInterface(JavaInterface javaInterface) throws InvalidInterfaceException {
        if (!javaInterface.isRemotable()) {
            return;
        }
        for (Operation operation : javaInterface.getOperations()) {
            DataBinding dbObj;
            WrapperHandler handler;
            WrapperInfo inputWrapperInfo = operation.getInputWrapper();
            WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
            if (inputWrapperInfo == null || outputWrapperInfo == null) continue;
            String db = inputWrapperInfo.getDataBinding();
            if (db == null || JAXB_DATABINDING.equals(db)) {
                db = this.assignOperationDataBinding(operation);
            }
            WrapperHandler wrapperHandler = handler = (dbObj = this.dataBindingRegistry.getDataBinding(db)) == null ? null : dbObj.getWrapperHandler();
            if (handler != null) {
                inputWrapperInfo.setWrapperType(handler.getWrapperType(operation, true));
                outputWrapperInfo.setWrapperType(handler.getWrapperType(operation, false));
            }
            if (dbObj == null || handler != null) continue;
            inputWrapperInfo.setWrapperType(null);
            outputWrapperInfo.setWrapperType(null);
        }
    }

    private String assignOperationDataBinding(Operation operation) {
        HashSet<String> dbs = new HashSet<String>();
        LinkedList<DataType> opDataTypes = new LinkedList<DataType>();
        opDataTypes.addAll((Collection)operation.getInputType().getLogical());
        opDataTypes.add(operation.getOutputType());
        for (DataType d : opDataTypes) {
            if (d == null) continue;
            String dataBinding = d.getDataBinding();
            if ("java:array".equals(dataBinding)) {
                dataBinding = ((DataType)d.getLogical()).getDataBinding();
            }
            if (dataBinding == null) continue;
            dbs.add(dataBinding);
        }
        dbs.remove("java:complexType");
        dbs.remove("java:simpleType");
        if (dbs.size() == 1) {
            String db = (String)dbs.iterator().next();
            operation.getInputWrapper().setDataBinding(db);
            return db;
        }
        return operation.getInputWrapper().getDataBinding();
    }
}

