/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import java.util.List;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Output2OutputTransformer
extends BaseTransformer<Object, Object>
implements PullTransformer<Object, Object> {
    protected Mediator mediator;

    @Reference
    public void setMediator(Mediator mediator) {
        this.mediator = mediator;
    }

    @Override
    public String getSourceDataBinding() {
        return "idl:output";
    }

    @Override
    public String getTargetDataBinding() {
        return "idl:output";
    }

    @Override
    protected Class<Object> getSourceType() {
        return Object.class;
    }

    @Override
    protected Class<Object> getTargetType() {
        return Object.class;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    private String getDataBinding(Operation operation) {
        WrapperInfo wrapper = operation.getOutputWrapper();
        if (wrapper != null) {
            return wrapper.getDataBinding();
        }
        return null;
    }

    private WrapperHandler getWrapperHandler(String dataBindingId, boolean required) {
        WrapperHandler wrapperHandler = null;
        if (dataBindingId != null) {
            DataBinding dataBinding = this.mediator.getDataBindings().getDataBinding(dataBindingId);
            WrapperHandler wrapperHandler2 = wrapperHandler = dataBinding == null ? null : dataBinding.getWrapperHandler();
        }
        if (wrapperHandler == null && required) {
            throw new TransformationException("No wrapper handler is provided for databinding: " + dataBindingId);
        }
        return wrapperHandler;
    }

    private boolean matches(WrapperInfo w1, WrapperInfo w2) {
        if (w1 == null || w2 == null) {
            return false;
        }
        if (!w1.getWrapperElement().equals(w2.getWrapperElement())) {
            return false;
        }
        List<ElementInfo> list1 = w1.getChildElements();
        List<ElementInfo> list2 = w2.getChildElements();
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            String n2;
            String n1 = list1.get(i).getQName().getLocalPart();
            if (n1.equals(n2 = list2.get(i).getQName().getLocalPart())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object transform(Object response, TransformationContext context) {
        try {
            DataType sourceType = context.getSourceDataType();
            Operation sourceOp = context.getSourceOperation();
            boolean sourceWrapped = sourceOp != null && sourceOp.isOutputWrapperStyle() && sourceOp.getOutputWrapper() != null;
            boolean sourceBare = sourceOp != null && !sourceOp.isOutputWrapperStyle() && sourceOp.getOutputWrapper() == null;
            WrapperHandler sourceWrapperHandler = null;
            String sourceDataBinding = this.getDataBinding(sourceOp);
            sourceWrapperHandler = this.getWrapperHandler(sourceDataBinding, sourceWrapped);
            DataType targetType = context.getTargetDataType();
            Operation targetOp = context.getTargetOperation();
            boolean targetWrapped = targetOp != null && targetOp.isOutputWrapperStyle() && targetOp.getOutputWrapper() != null;
            boolean targetBare = targetOp != null && !targetOp.isOutputWrapperStyle() && targetOp.getOutputWrapper() == null;
            WrapperHandler targetWrapperHandler = null;
            String targetDataBinding = this.getDataBinding(targetOp);
            targetWrapperHandler = this.getWrapperHandler(targetDataBinding, targetWrapped);
            if (!sourceWrapped && !sourceBare && targetWrapped) {
                Class<?> targetWrapperClass;
                WrapperInfo wrapper = targetOp.getOutputWrapper();
                ElementInfo wrapperElement = wrapper.getWrapperElement();
                List<ElementInfo> childElements = wrapper.getChildElements();
                Class<?> clazz = targetWrapperClass = wrapper != null ? wrapper.getWrapperClass() : null;
                if (sourceWrapperHandler != null) {
                    DataType<XMLType> sourceWrapperType;
                    WrapperInfo sourceWrapperInfo = sourceOp.getOutputWrapper();
                    DataType<XMLType> dataType = sourceWrapperType = sourceWrapperInfo != null ? sourceWrapperInfo.getWrapperType() : null;
                    if (sourceWrapperType != null && this.matches(sourceOp.getOutputWrapper(), targetOp.getOutputWrapper())) {
                        Class<?> sourceWrapperClass = sourceWrapperType.getPhysical();
                        Object sourceWrapper = sourceWrapperHandler.create(sourceOp, false);
                        if (sourceWrapper != null) {
                            if (!childElements.isEmpty()) {
                                sourceWrapperHandler.setChildren(sourceWrapper, new Object[]{response}, sourceOp, false);
                            }
                            Object targetWrapper = this.mediator.mediate(sourceWrapper, sourceWrapperType, (DataType)targetType.getLogical(), context.getMetadata());
                            return targetWrapper;
                        }
                    }
                }
                Object targetWrapper = targetWrapperHandler.create(targetOp, false);
                if (childElements.isEmpty()) {
                    return targetWrapper;
                }
                DataType argType = wrapper.getUnwrappedOutputType();
                Object child = response;
                child = this.mediator.mediate(response, (DataType)sourceType.getLogical(), argType, context.getMetadata());
                targetWrapperHandler.setChildren(targetWrapper, new Object[]{child}, targetOp, false);
                return targetWrapper;
            }
            if (sourceWrapped && !targetWrapped && !targetBare) {
                Object sourceWrapper = response;
                List<ElementInfo> childElements = sourceOp.getOutputWrapper().getChildElements();
                if (childElements.isEmpty()) {
                    return null;
                }
                if (targetWrapperHandler != null) {
                    ElementInfo wrapperElement = sourceOp.getOutputWrapper().getWrapperElement();
                    if (sourceWrapperHandler.isInstance(sourceWrapper, sourceOp, false)) {
                        DataType<XMLType> targetWrapperType;
                        WrapperInfo targetWrapperInfo = targetOp.getOutputWrapper();
                        DataType<XMLType> dataType = targetWrapperType = targetWrapperInfo != null ? targetWrapperInfo.getWrapperType() : null;
                        if (targetWrapperType != null && this.matches(sourceOp.getOutputWrapper(), targetOp.getOutputWrapper())) {
                            Object targetWrapper = this.mediator.mediate(sourceWrapper, (DataType)sourceType.getLogical(), targetWrapperType, context.getMetadata());
                            return targetWrapperHandler.getChildren(targetWrapper, targetOp, false).get(0);
                        }
                    }
                }
                Object child = sourceWrapperHandler.getChildren(sourceWrapper, sourceOp, false).get(0);
                DataType childType = sourceOp.getOutputWrapper().getUnwrappedOutputType();
                return this.mediator.mediate(child, childType, (DataType)targetType.getLogical(), context.getMetadata());
            }
            return this.mediator.mediate(response, (DataType)sourceType.getLogical(), (DataType)targetType.getLogical(), context.getMetadata());
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }
}

