/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.wire;

import java.util.HashMap;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class DataTransformationInterceptor
implements Interceptor,
DataExchangeSemantics {
    private Invoker next;
    private Operation sourceOperation;
    private Operation targetOperation;
    private RuntimeWire wire;
    private Mediator mediator;

    public DataTransformationInterceptor(RuntimeWire wire, Operation sourceOperation, Operation targetOperation, Mediator mediator) {
        this.sourceOperation = sourceOperation;
        this.targetOperation = targetOperation;
        this.mediator = mediator;
        this.wire = wire;
    }

    public Invoker getNext() {
        return this.next;
    }

    public Message invoke(Message msg) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("wire", this.wire);
        Object input = this.mediator.mediateInput(msg.getBody(), this.sourceOperation, this.targetOperation, metadata);
        msg.setBody(input);
        Message resultMsg = this.next.invoke(msg);
        if (this.sourceOperation.isNonBlocking()) {
            return resultMsg;
        }
        Object result = resultMsg.getBody();
        if (resultMsg.isFault()) {
            Object transformedFault = null;
            if (result instanceof Exception && !(result instanceof RuntimeException) && (transformedFault = this.mediator.mediateFault(result, this.sourceOperation, this.targetOperation, metadata)) != result) {
                resultMsg.setFaultBody(transformedFault);
            }
        } else {
            assert (!(result instanceof Throwable)) : "Expected messages that are not throwable " + result;
            Object newResult = this.mediator.mediateOutput(result, this.sourceOperation, this.targetOperation, metadata);
            if (newResult != result) {
                resultMsg.setBody(newResult);
            }
        }
        return resultMsg;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public boolean allowsPassByReference() {
        return true;
    }
}

