/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.wire;

import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;

public class PassByValueInterceptor
implements Interceptor {
    private Mediator mediator;
    private Operation operation;
    private Invoker nextInvoker;
    private InvocationChain chain;

    public PassByValueInterceptor(Mediator mediator, InvocationChain chain, Operation operation) {
        this.mediator = mediator;
        this.chain = chain;
        this.operation = operation;
    }

    public Message invoke(Message msg) {
        if (this.chain.allowsPassByReference()) {
            return this.nextInvoker.invoke(msg);
        }
        msg.setBody(this.mediator.copyInput(msg.getBody(), this.operation));
        Message resultMsg = this.nextInvoker.invoke(msg);
        if (!resultMsg.isFault() && this.operation.getOutputType() != null) {
            resultMsg.setBody(this.mediator.copyOutput(resultMsg.getBody(), this.operation));
        }
        if (resultMsg.isFault()) {
            resultMsg.setFaultBody(this.mediator.copyFault(resultMsg.getBody(), this.operation));
        }
        return resultMsg;
    }

    public Invoker getNext() {
        return this.nextInvoker;
    }

    public void setNext(Invoker next) {
        this.nextInvoker = next;
    }
}

