/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.lang.reflect.Method;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.tuscany.sca.core.context.CallableReferenceImpl;
import org.apache.tuscany.sca.core.context.ServiceReferenceImpl;
import org.apache.tuscany.sca.core.invocation.CallbackReferenceImpl;
import org.apache.tuscany.sca.core.invocation.JDKCallbackInvocationHandler;
import org.apache.tuscany.sca.core.invocation.JDKInvocationHandler;
import org.apache.tuscany.sca.core.invocation.ProxyCreationException;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.CallableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CglibProxyFactory
implements ProxyFactory {
    private MessageFactory messageFactory;

    public CglibProxyFactory(MessageFactory messageFactory, InterfaceContractMapper mapper) {
        this.messageFactory = messageFactory;
    }

    @Override
    public <T> T createProxy(Class<T> interfaze, RuntimeWire wire) throws ProxyCreationException {
        ServiceReferenceImpl<T> serviceReference = new ServiceReferenceImpl<T>(interfaze, wire, this);
        return this.createProxy(serviceReference);
    }

    @Override
    public <T> T createProxy(CallableReference<T> callableReference) throws ProxyCreationException {
        Enhancer enhancer = new Enhancer();
        Class<T> interfaze = callableReference.getBusinessInterface();
        CglibClassLoader cl = new CglibClassLoader(interfaze.getClassLoader(), this.getClass().getClassLoader());
        enhancer.setClassLoader((ClassLoader)cl);
        enhancer.setSuperclass(interfaze);
        enhancer.setCallback(new CglibMethodInterceptor<T>(callableReference));
        Object proxy = enhancer.create();
        ((CallableReferenceImpl)callableReference).setProxy(proxy);
        return interfaze.cast(proxy);
    }

    @Override
    public <T> T createCallbackProxy(Class<T> interfaze, List<RuntimeWire> wires) throws ProxyCreationException {
        CallbackReferenceImpl callbackReference = CallbackReferenceImpl.newInstance(interfaze, this, wires);
        return callbackReference != null ? (T)this.createCallbackProxy(callbackReference) : null;
    }

    @Override
    public <T> T createCallbackProxy(CallbackReferenceImpl<T> callbackReference) throws ProxyCreationException {
        Enhancer enhancer = new Enhancer();
        Class interfaze = callbackReference.getBusinessInterface();
        enhancer.setSuperclass(interfaze);
        enhancer.setCallback(new CglibMethodInterceptor<T>(callbackReference));
        Object proxy = enhancer.create();
        callbackReference.setProxy(proxy);
        return (T)interfaze.cast(proxy);
    }

    @Override
    public <B, R extends CallableReference<B>> R cast(B target) throws IllegalArgumentException {
        if (this.isProxyClass(target.getClass())) {
            Factory factory = (Factory)target;
            Callback[] callbacks = factory.getCallbacks();
            if (callbacks.length != 1 || !(callbacks[0] instanceof CglibMethodInterceptor)) {
                throw new IllegalArgumentException("The object is not a known proxy.");
            }
            CglibMethodInterceptor interceptor = (CglibMethodInterceptor)callbacks[0];
            return (R)interceptor.invocationHandler.getCallableReference();
        }
        throw new IllegalArgumentException("The object is not a known proxy.");
    }

    @Override
    public boolean isProxyClass(Class<?> clazz) {
        return Factory.class.isAssignableFrom(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CglibMethodInterceptor<T>
    implements MethodInterceptor {
        private JDKInvocationHandler invocationHandler;

        public CglibMethodInterceptor(CallableReference<T> callableReference) {
            this.invocationHandler = new JDKInvocationHandler(CglibProxyFactory.this.messageFactory, callableReference);
        }

        public CglibMethodInterceptor(CallbackReferenceImpl<T> callbackReference) {
            this.invocationHandler = new JDKCallbackInvocationHandler(CglibProxyFactory.this.messageFactory, callbackReference);
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Object result = this.invocationHandler.invoke(proxy, method, args);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CglibClassLoader
    extends ClassLoader {
        private ClassLoader appLoader;
        private ClassLoader bundleLoader;

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            try {
                return this.appLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                return this.bundleLoader.loadClass(className);
            }
        }

        CglibClassLoader(ClassLoader app, ClassLoader bundle) {
            this.appLoader = app;
            this.bundleLoader = bundle;
        }
    }
}

