/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.JDKProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.invocation.MessageFactory;

public class DefaultProxyFactoryExtensionPoint
implements ProxyFactoryExtensionPoint {
    private InterfaceContractMapper interfaceContractMapper;
    private MessageFactory messageFactory;
    private ProxyFactory interfaceFactory;
    private ProxyFactory classFactory;

    public DefaultProxyFactoryExtensionPoint(ExtensionPointRegistry extensionPoints) {
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
        ModelFactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.messageFactory = modelFactories.getFactory(MessageFactory.class);
        this.interfaceFactory = new JDKProxyFactory(this.messageFactory, this.interfaceContractMapper);
    }

    public DefaultProxyFactoryExtensionPoint(MessageFactory messageFactory, InterfaceContractMapper mapper) {
        this.interfaceContractMapper = mapper;
        this.messageFactory = messageFactory;
        this.interfaceFactory = new JDKProxyFactory(messageFactory, mapper);
    }

    public ProxyFactory getClassProxyFactory() {
        return this.classFactory;
    }

    public ProxyFactory getInterfaceProxyFactory() {
        return this.interfaceFactory;
    }

    public void setClassProxyFactory(ProxyFactory factory) {
        this.classFactory = factory;
    }

    public void setInterfaceProxyFactory(ProxyFactory factory) {
        this.interfaceFactory = factory;
    }
}

