/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.core.assembly.RuntimeWireImpl;
import org.apache.tuscany.sca.core.context.CallableReferenceImpl;
import org.apache.tuscany.sca.core.conversation.ConversationState;
import org.apache.tuscany.sca.core.invocation.CallbackReferenceImpl;
import org.apache.tuscany.sca.core.invocation.JDKInvocationHandler;
import org.apache.tuscany.sca.core.scope.TargetResolutionException;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.NoRegisteredCallbackException;
import org.osoa.sca.ServiceRuntimeException;

public class JDKCallbackInvocationHandler
extends JDKInvocationHandler {
    private static final long serialVersionUID = -3350283555825935609L;

    public JDKCallbackInvocationHandler(MessageFactory messageFactory, CallbackReferenceImpl ref) {
        super(messageFactory, ref);
        this.fixedWire = false;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class == method.getDeclaringClass()) {
            return this.invokeObjectMethod(method, args);
        }
        RuntimeWire wire = ((CallbackReferenceImpl)this.callableReference).getCallbackWire();
        if (wire == null) {
            throw new ServiceRuntimeException("No callback wire found");
        }
        this.initConversational(wire);
        if (this.conversational) {
            Object convID;
            if (this.conversation == null || this.conversation.getState() == ConversationState.ENDED) {
                this.conversation = null;
            }
            Object object = convID = this.conversation == null ? null : this.conversation.getConversationID();
            if (convID == null && (convID = ((CallbackReferenceImpl)this.callableReference).getConvID()) != null) {
                this.conversation = ((RuntimeWireImpl)wire).getConversationManager().getConversation(convID);
                if (this.callableReference != null) {
                    ((CallableReferenceImpl)this.callableReference).attachConversation(this.conversation);
                }
            }
        }
        this.setEndpoint(((CallbackReferenceImpl)this.callableReference).getResolvedEndpoint());
        InvocationChain chain = this.getInvocationChain(method, wire);
        if (chain == null) {
            throw new IllegalArgumentException("No matching operation is found: " + method);
        }
        try {
            Object object = this.invoke(chain, args, wire, wire.getSource());
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof NoRegisteredCallbackException) {
                throw t;
            }
            throw e;
        }
        finally {
            ((RuntimeWireImpl)wire).releaseWire();
        }
    }

    protected void handleCallback(Message msg, RuntimeWire wire, Object currentConversationID) throws TargetResolutionException {
        ReferenceParameters parameters = msg.getFrom().getReferenceParameters();
        parameters.setCallbackID(this.getCallbackID());
    }
}

