/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.core.invocation.ThreadMessageContext;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.osoa.sca.ServiceRuntimeException;

public class NonBlockingInterceptor
implements Interceptor {
    private static final Message RESPONSE = new ImmutableMessage();
    private static final Logger LOGGER = Logger.getLogger(NonBlockingInterceptor.class.getName());
    private WorkScheduler workScheduler;
    private Invoker next;

    public NonBlockingInterceptor(WorkScheduler workScheduler) {
        this.workScheduler = workScheduler;
    }

    public NonBlockingInterceptor(WorkScheduler workScheduler, Interceptor next) {
        this.workScheduler = workScheduler;
        this.next = next;
    }

    public void setWorkScheduler(WorkScheduler workScheduler) {
        this.workScheduler = workScheduler;
    }

    public Message invoke(final Message msg) {
        try {
            this.workScheduler.scheduleWork(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Message context = ThreadMessageContext.setMessageContext(msg);
                    try {
                        Message response = null;
                        Throwable ex = null;
                        try {
                            response = NonBlockingInterceptor.this.next.invoke(msg);
                        }
                        catch (Throwable t) {
                            ex = t;
                        }
                        if (response != null && response.isFault()) {
                            ex = (Throwable)response.getBody();
                        }
                        if (ex != null) {
                            LOGGER.log(Level.SEVERE, "Exception from @OneWay invocation", ex);
                            throw new ServiceRuntimeException("Exception from @OneWay invocation", ex);
                        }
                    }
                    finally {
                        ThreadMessageContext.setMessageContext(context);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        return RESPONSE;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmutableMessage
    implements Message {
        private ImmutableMessage() {
        }

        public Object getBody() {
            return null;
        }

        public void setBody(Object body) {
            if (body != null) {
                throw new UnsupportedOperationException();
            }
        }

        public void setCallbackWires(LinkedList<RuntimeWire> wires) {
        }

        @Override
        public Object getMessageID() {
            return null;
        }

        @Override
        public void setMessageID(Object messageId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isFault() {
            return false;
        }

        public void setFaultBody(Object fault) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EndpointReference getFrom() {
            return null;
        }

        @Override
        public EndpointReference getTo() {
            return null;
        }

        @Override
        public void setFrom(EndpointReference from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTo(EndpointReference to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Operation getOperation() {
            return null;
        }

        @Override
        public void setOperation(Operation op) {
            throw new UnsupportedOperationException();
        }

        public EndpointReference getReplyTo() {
            return null;
        }

        public Map<String, Object> getQoSContext() {
            return null;
        }

        @Override
        public List<Object> getHeaders() {
            return null;
        }

        @Override
        public <T> T getBindingContext() {
            return null;
        }

        @Override
        public <T> void setBindingContext(T bindingContext) {
        }
    }
}

