/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.lang.reflect.InvocationTargetException;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.conversation.ConversationManager;
import org.apache.tuscany.sca.core.conversation.ConversationState;
import org.apache.tuscany.sca.core.conversation.ExtendedConversation;
import org.apache.tuscany.sca.core.invocation.ThreadMessageContext;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.ScopedRuntimeComponent;
import org.apache.tuscany.sca.core.scope.TargetDestructionException;
import org.apache.tuscany.sca.interfacedef.ConversationSequence;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.ConversationEndedException;
import org.osoa.sca.ServiceRuntimeException;

public class RuntimeWireInvoker
implements Invoker {
    protected ConversationManager conversationManager;
    protected boolean conversational;
    protected ExtendedConversation conversation;
    protected MessageFactory messageFactory;
    protected Object conversationID;
    protected Object callbackID;
    protected Object callbackObject;
    protected RuntimeWire wire;

    public RuntimeWireInvoker(MessageFactory messageFactory, ConversationManager conversationManager, RuntimeWire wire) {
        this.messageFactory = messageFactory;
        this.wire = wire;
        this.conversationManager = conversationManager;
        this.init(wire);
    }

    protected void init(RuntimeWire wire) {
        if (wire != null) {
            ReferenceParameters parameters = wire.getSource().getReferenceParameters();
            this.callbackID = parameters.getCallbackID();
            this.callbackObject = parameters.getCallbackReference();
            this.conversationID = parameters.getConversationID();
            InterfaceContract contract = wire.getSource().getInterfaceContract();
            this.conversational = contract.getInterface().isConversational();
        }
    }

    public Message invoke(Message msg) {
        try {
            Object response = this.invoke(msg.getOperation(), msg);
            msg.setBody(response);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return msg;
    }

    public Object invoke(Operation operation, Message msg) throws InvocationTargetException {
        return this.invoke(this.wire, operation, msg);
    }

    public Object invoke(RuntimeWire wire, Operation operation, Message msg) throws InvocationTargetException {
        RuntimeWire runtimeWire = wire == null ? this.wire : wire;
        InvocationChain chain = runtimeWire.getInvocationChain(operation);
        return this.invoke(chain, msg, runtimeWire);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invoke(InvocationChain chain, Message msg, RuntimeWire wire) throws InvocationTargetException {
        EndpointReference from = msg.getFrom();
        EndpointReference epFrom = wire.getSource();
        if (from != null) {
            from.mergeEndpoint(epFrom);
        } else {
            msg.setFrom(epFrom);
        }
        msg.setTo(wire.getTarget());
        Invoker headInvoker = chain.getHeadInvoker();
        Operation operation = chain.getTargetOperation();
        msg.setOperation(operation);
        Message msgContext = ThreadMessageContext.getMessageContext();
        Object currentConversationID = msgContext.getFrom().getReferenceParameters().getConversationID();
        ThreadMessageContext.setMessageContext(msg);
        try {
            this.conversationPreinvoke(msg);
            Message resp = headInvoker.invoke(msg);
            Object body = resp.getBody();
            if (resp.isFault()) {
                throw new InvocationTargetException((Throwable)body);
            }
            Object t = body;
            return t;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
        finally {
            try {
                this.conversationPostInvoke(msg);
            }
            catch (TargetDestructionException e) {
                throw new ServiceRuntimeException(e);
            }
            finally {
                ThreadMessageContext.setMessageContext(msgContext);
            }
        }
    }

    protected EndpointReference getCallbackEndpoint(Message msgContext) {
        EndpointReference from = msgContext.getFrom();
        return from == null ? null : from.getReferenceParameters().getCallbackReference();
    }

    private void conversationPreinvoke(Message msg) {
        if (this.conversational) {
            ReferenceParameters parameters = msg.getFrom().getReferenceParameters();
            Object convID = parameters.getConversationID();
            if (convID != null) {
                this.conversationID = convID;
            }
            this.conversation = this.conversationManager.getConversation(this.conversationID);
            if (this.conversation == null || this.conversation.getState() == ConversationState.ENDED) {
                this.conversation = this.conversationManager.startConversation(this.conversationID);
                this.conversation.initializeConversationAttributes(this.wire.getTarget().getComponent());
            } else if (!this.conversation.conversationalAttributesInitialized()) {
                this.conversation.initializeConversationAttributes(this.wire.getTarget().getComponent());
            } else if (this.conversation.isExpired()) {
                throw new ConversationEndedException("Conversation has expired.");
            }
            this.conversation.updateLastReferencedTime();
            parameters.setConversationID(this.conversation.getConversationID());
        }
    }

    private void conversationPostInvoke(Message msg) throws TargetDestructionException {
        Operation operation;
        ConversationSequence sequence;
        if (this.conversational && (sequence = (operation = msg.getOperation()).getConversationSequence()) == ConversationSequence.CONVERSATION_END) {
            Object convID = msg.getFrom().getReferenceParameters().getConversationID();
            if (convID != null) {
                this.conversationID = convID;
            }
            this.conversation = this.conversationManager.getConversation(this.conversationID);
            ScopeContainer scopeContainer = this.getConversationalScopeContainer(msg);
            if (scopeContainer != null) {
                scopeContainer.remove(this.conversation.getConversationID());
            }
            this.conversation.end();
        }
    }

    private ScopeContainer getConversationalScopeContainer(Message msg) {
        ScopedRuntimeComponent scopedRuntimeComponent;
        ScopeContainer container;
        ScopeContainer scopeContainer = null;
        RuntimeComponent component = msg.getTo().getComponent();
        if (component instanceof ScopedRuntimeComponent && (container = (scopedRuntimeComponent = (ScopedRuntimeComponent)component).getScopeContainer()) != null && container.getScope() == Scope.CONVERSATION) {
            scopeContainer = container;
        }
        return scopeContainer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallbackObjectWrapper<T>
    implements InstanceWrapper<T> {
        private T instance;

        private CallbackObjectWrapper(T instance) {
            this.instance = instance;
        }

        @Override
        public T getInstance() {
            return this.instance;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }
    }
}

