/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.work;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tuscany.sca.core.work.ThreadPoolWorkManager;
import org.apache.tuscany.sca.core.work.Work;
import org.apache.tuscany.sca.core.work.WorkEvent;
import org.apache.tuscany.sca.core.work.WorkListener;
import org.apache.tuscany.sca.work.NotificationListener;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.apache.tuscany.sca.work.WorkSchedulerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkScheduler
implements WorkScheduler {
    private ThreadPoolWorkManager jsr237WorkManager;

    private synchronized ThreadPoolWorkManager getWorkManager() {
        if (this.jsr237WorkManager != null) {
            return this.jsr237WorkManager;
        }
        if (this.jsr237WorkManager == null) {
            this.jsr237WorkManager = new ThreadPoolWorkManager(0);
        }
        return this.jsr237WorkManager;
    }

    @Override
    public <T extends Runnable> void scheduleWork(T work) {
        this.scheduleWork(work, null);
    }

    @Override
    public <T extends Runnable> void scheduleWork(T work, NotificationListener<T> listener) {
        if (work == null) {
            throw new IllegalArgumentException("Work cannot be null");
        }
        Work<T> jsr237Work = new Work<T>(work);
        try {
            if (listener == null) {
                this.getWorkManager().schedule(jsr237Work);
            } else {
                Jsr237WorkListener jsr237WorkListener = new Jsr237WorkListener(this, listener, work);
                this.getWorkManager().schedule(jsr237Work, jsr237WorkListener);
            }
        }
        catch (IllegalArgumentException ex) {
            if (listener != null) {
                listener.workRejected(work);
            }
            throw new WorkSchedulerException(ex);
        }
        catch (Exception ex) {
            throw new WorkSchedulerException(ex);
        }
    }

    @Override
    public void destroy() {
        if (this.jsr237WorkManager instanceof ThreadPoolWorkManager) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    DefaultWorkScheduler.this.jsr237WorkManager.destroy();
                    return null;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Jsr237WorkListener<T extends Runnable>
    implements WorkListener {
        private NotificationListener<T> listener;
        private T work;
        final /* synthetic */ DefaultWorkScheduler this$0;

        public Jsr237WorkListener(NotificationListener<T> listener, T work) {
            this.this$0 = var1_1;
            this.listener = listener;
            this.work = work;
        }

        @Override
        public void workAccepted(WorkEvent workEvent) {
            T work = this.getWork();
            this.listener.workAccepted(work);
        }

        @Override
        public void workRejected(WorkEvent workEvent) {
            T work = this.getWork();
            this.listener.workRejected(work);
        }

        @Override
        public void workStarted(WorkEvent workEvent) {
            T work = this.getWork();
            this.listener.workStarted(work);
        }

        @Override
        public void workCompleted(WorkEvent workEvent) {
            T work = this.getWork();
            WorkSchedulerException exception = workEvent.getException();
            if (exception != null) {
                this.listener.workFailed(work, exception);
            } else {
                this.listener.workCompleted(work);
            }
        }

        private T getWork() {
            return this.work;
        }
    }
}

