/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.impl;

import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.SimpleTypeMapper;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Java2SimpleTypeTransformer<T>
extends BaseTransformer<Object, T>
implements PullTransformer<Object, T> {
    protected SimpleTypeMapper mapper;

    public Java2SimpleTypeTransformer() {
        this.mapper = new SimpleTypeMapperImpl();
    }

    public Java2SimpleTypeTransformer(SimpleTypeMapper mapper) {
        this.mapper = mapper != null ? mapper : new SimpleTypeMapperImpl();
    }

    @Override
    public T transform(Object source, TransformationContext context) {
        XMLType xmlType = (XMLType)context.getTargetDataType().getLogical();
        String text = this.mapper.toXMLLiteral(xmlType.getTypeName(), source, context);
        return this.createElement(xmlType.getElementName(), text, context);
    }

    @Override
    public Class<Object> getSourceType() {
        return Object.class;
    }

    @Override
    public int getWeight() {
        return 10000;
    }

    protected abstract T createElement(QName var1, String var2, TransformationContext var3);

    @Override
    public String getSourceDataBinding() {
        return "java:simpleType";
    }
}

