/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.javabeans;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tuscany.sca.databinding.impl.DOMHelper;
import org.apache.tuscany.sca.databinding.javabeans.Java2XMLMapperException;
import org.apache.tuscany.sca.databinding.javabeans.JavaBean2XMLTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBean2DOMNodeTransformer
extends JavaBean2XMLTransformer<Node> {
    public static final String COLON = ":";
    private Document factory;

    public JavaBean2DOMNodeTransformer() {
        try {
            this.factory = DOMHelper.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new Java2XMLMapperException(e);
        }
    }

    @Override
    public void appendChild(Node parentElement, Node childElement) throws Java2XMLMapperException {
        parentElement.appendChild(childElement);
    }

    @Override
    public Node createElement(QName qName) throws Java2XMLMapperException {
        String qualifedName = qName.getPrefix() == null || qName.getPrefix().length() <= 0 ? qName.getLocalPart() : qName.getPrefix() + COLON + qName.getLocalPart();
        return this.factory.createElementNS(qName.getNamespaceURI(), qualifedName);
    }

    @Override
    public void appendText(Node parentElement, String textData) throws Java2XMLMapperException {
        Node textNode;
        if (textData != null) {
            textNode = this.factory.createTextNode(textData);
        } else {
            Attr nil = this.factory.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil");
            nil.setValue("true");
            textNode = nil;
        }
        this.appendChild(parentElement, textNode);
    }

    @Override
    public Class getTargetType() {
        return Node.class;
    }
}

