/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.javabeans;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.databinding.javabeans.XML2JavaMapperException;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XML2JavaBeanTransformer<T>
extends BaseTransformer<T, Object>
implements PullTransformer<T, Object> {
    public static final String SET = "set";
    public static final QName QNAME_MESSAGE = new QName("message");
    protected SimpleTypeMapperImpl mapper = new SimpleTypeMapperImpl();

    @Override
    public int getWeight() {
        return 10000;
    }

    @Override
    public Object transform(T source, TransformationContext context) {
        if (context.getSourceDataType().getLogical() instanceof XMLType) {
            XMLType xmlType = (XMLType)context.getSourceDataType().getLogical();
            return this.toJavaObject(xmlType.getTypeName(), this.getRootElement(source), context);
        }
        return this.toJavaObject(null, this.getRootElement(source), context);
    }

    public Object toJavaObject(QName xmlType, T xmlElement, TransformationContext context) {
        if (xmlType != null && SimpleTypeMapperImpl.isSimpleXSDType(xmlType)) {
            return this.mapper.toJavaObject(xmlType, this.getText(xmlElement), context);
        }
        Class<?> javaType = context.getTargetDataType().getPhysical();
        return this.createJavaObject(xmlElement, javaType, context);
    }

    private <L> L createJavaObject(T element, Class<L> javaType, TransformationContext context) throws XML2JavaMapperException {
        if (this.isTextOnly(element)) {
            return (L)this.mapper.toJavaObject(SimpleTypeMapperImpl.getXMLType(javaType).getQName(), this.getText(element), context);
        }
        String fieldName = null;
        try {
            L javaInstance;
            T detailMsg = null;
            if (Throwable.class.isAssignableFrom(javaType)) {
                T msgElement = this.getFirstChildWithName(element, QNAME_MESSAGE);
                if (msgElement != null && this.isTextOnly(msgElement)) {
                    detailMsg = msgElement;
                    Constructor<L> constructor = javaType.getConstructor(String.class);
                    javaInstance = constructor.newInstance(this.getText(detailMsg));
                } else {
                    javaInstance = javaType.newInstance();
                }
            } else {
                javaInstance = javaType.newInstance();
            }
            Hashtable<Field, List<Object>> arrayFields = new Hashtable<Field, List<Object>>();
            Hashtable<Method, List<Object>> arraySetters = new Hashtable<Method, List<Object>>();
            Iterator<T> childElements = this.getChildElements(element);
            while (childElements.hasNext()) {
                T childElement = childElements.next();
                if (this.isTextElement(childElement) || childElement == detailMsg) continue;
                fieldName = this.getElementName(childElement);
                try {
                    Field javaField = javaType.getField(fieldName);
                    this.setFieldValue(javaInstance, javaField, childElement, arrayFields, context);
                }
                catch (NoSuchFieldException e1) {
                    this.setFieldValueUsingSetter(javaType, javaInstance, fieldName, childElement, arraySetters, context);
                }
            }
            this.setArrayValues(javaInstance, arrayFields, arraySetters);
            return javaInstance;
        }
        catch (Exception e2) {
            XML2JavaMapperException xml2JavaEx = new XML2JavaMapperException(e2);
            xml2JavaEx.setJavaType(javaType);
            xml2JavaEx.setJavaFieldName(fieldName);
            throw xml2JavaEx;
        }
    }

    private void setFieldValue(Object javaInstance, Field javaField, T fieldValue, Map<Field, List<Object>> arrayFields, TransformationContext context) throws IllegalAccessException {
        Class<?> javaFieldType = javaField.getType();
        if (javaFieldType.isArray()) {
            Class<?> componentType = javaFieldType.getComponentType();
            List<Object> fldValueArray = arrayFields.get(javaField);
            if (fldValueArray == null) {
                fldValueArray = new ArrayList<Object>();
                arrayFields.put(javaField, fldValueArray);
            }
            fldValueArray.add(this.createJavaObject(fieldValue, componentType, context));
        } else {
            javaField.setAccessible(true);
            javaField.set(javaInstance, this.createJavaObject(fieldValue, javaFieldType, context));
        }
    }

    private void setFieldValueUsingSetter(Class javaType, Object javaInstance, String fieldName, T fieldValue, Map<Method, List<Object>> arraySetters, TransformationContext context) throws IllegalAccessException, InvocationTargetException {
        char firstChar = Character.toUpperCase(fieldName.charAt(0));
        StringBuilder methodName = new StringBuilder(SET + fieldName);
        methodName.setCharAt(SET.length(), firstChar);
        boolean methodNotFound = true;
        for (int methodCount = 0; methodNotFound && methodCount < javaType.getMethods().length; ++methodCount) {
            Method aMethod = javaType.getMethods()[methodCount];
            if (!aMethod.getName().equals(methodName.toString()) || aMethod.getParameterTypes().length != 1) continue;
            Class<?> paramType = aMethod.getParameterTypes()[0];
            if (paramType.isArray()) {
                Class<?> componentType = paramType.getComponentType();
                List<Object> setterValueArray = arraySetters.get(aMethod);
                if (setterValueArray == null) {
                    setterValueArray = new ArrayList<Object>();
                    arraySetters.put(aMethod, setterValueArray);
                }
                setterValueArray.add(this.createJavaObject(fieldValue, componentType, context));
            } else {
                aMethod.invoke(javaInstance, this.createJavaObject(fieldValue, paramType, context));
            }
            methodNotFound = false;
        }
        if (methodNotFound) {
            XML2JavaMapperException xml2JavaEx = new XML2JavaMapperException("No field or setter method to configure xml data");
            xml2JavaEx.setJavaFieldName(fieldName);
            xml2JavaEx.setJavaType(javaType);
            throw xml2JavaEx;
        }
    }

    private void setArrayValues(Object javaInstance, Map<Field, List<Object>> arrayFields, Map<Method, List<Object>> arraySetters) throws IllegalAccessException, InvocationTargetException {
        if (arrayFields.size() > 0) {
            for (Field javaField : arrayFields.keySet()) {
                javaField.setAccessible(true);
                if (javaField.getType().getComponentType().isPrimitive()) {
                    javaField.set(javaInstance, this.createPrimitiveArray(javaField.getType().getComponentType(), arrayFields.get(javaField)));
                    continue;
                }
                javaField.set(javaInstance, this.createNonPrimitiveArray(javaField.getType().getComponentType(), arrayFields.get(javaField)));
            }
        }
        if (arraySetters.size() > 0) {
            for (Method aMethod : arraySetters.keySet()) {
                Class<?> paramType = aMethod.getParameterTypes()[0];
                if (paramType.getComponentType().isPrimitive()) {
                    aMethod.invoke(javaInstance, this.createPrimitiveArray(paramType.getComponentType(), arraySetters.get(aMethod)));
                    continue;
                }
                aMethod.invoke(javaInstance, this.createNonPrimitiveArray(paramType.getComponentType(), arraySetters.get(aMethod)));
            }
        }
    }

    private Object createNonPrimitiveArray(Class fieldType, List values) {
        Object objectArray = Array.newInstance(fieldType, values.size());
        for (int count = 0; count < values.size(); ++count) {
            Array.set(objectArray, count, values.get(count));
        }
        return objectArray;
    }

    private Object createPrimitiveArray(Class fieldType, List values) {
        if (fieldType.isPrimitive()) {
            if (fieldType.getName().equals("int")) {
                int[] primitiveValues = new int[values.size()];
                for (int count = 0; count < values.size(); ++count) {
                    primitiveValues[count] = (Integer)values.get(count);
                }
                return primitiveValues;
            }
            if (fieldType.getName().equals("float")) {
                float[] primitiveValues = new float[values.size()];
                for (int count = 0; count < values.size(); ++count) {
                    primitiveValues[count] = ((Float)values.get(count)).floatValue();
                }
                return primitiveValues;
            }
            if (fieldType.getName().equals("boolean")) {
                boolean[] primitiveValues = new boolean[values.size()];
                for (int count = 0; count < values.size(); ++count) {
                    primitiveValues[count] = (Boolean)values.get(count);
                }
                return primitiveValues;
            }
            if (fieldType.getName().equals("char")) {
                char[] primitiveValues = new char[values.size()];
                for (int count = 0; count < values.size(); ++count) {
                    primitiveValues[count] = ((Character)values.get(count)).charValue();
                }
                return primitiveValues;
            }
            if (fieldType.getName().equals("byte")) {
                byte[] primitiveValues = new byte[values.size()];
                for (int count = 0; count < values.size(); ++count) {
                    primitiveValues[count] = (Byte)values.get(count);
                }
                return primitiveValues;
            }
            if (fieldType.getName().equals("short")) {
                short[] primitiveValues = new short[values.size()];
                for (int count = 0; count < values.size(); ++count) {
                    primitiveValues[count] = (Short)values.get(count);
                }
                return primitiveValues;
            }
            if (fieldType.getName().equals("long")) {
                long[] primitiveValues = new long[values.size()];
                for (int count = 0; count < values.size(); ++count) {
                    primitiveValues[count] = (Long)values.get(count);
                }
                return primitiveValues;
            }
            if (fieldType.getName().equals("double")) {
                double[] primitiveValues = new double[values.size()];
                for (int count = 0; count < values.size(); ++count) {
                    primitiveValues[count] = (Double)values.get(count);
                }
                return primitiveValues;
            }
        }
        return values;
    }

    public abstract String getText(T var1) throws XML2JavaMapperException;

    public abstract Iterator<T> getChildElements(T var1) throws XML2JavaMapperException;

    public abstract String getElementName(T var1) throws XML2JavaMapperException;

    public abstract boolean isTextElement(T var1) throws XML2JavaMapperException;

    public abstract boolean isTextOnly(T var1) throws XML2JavaMapperException;

    public abstract T getFirstChildWithName(T var1, QName var2) throws XML2JavaMapperException;

    public abstract T getRootElement(T var1) throws XML2JavaMapperException;

    @Override
    public Class<Object> getTargetType() {
        return Object.class;
    }

    @Override
    public String getTargetDataBinding() {
        return "java:complexType";
    }
}

