/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.jaxb.DataConverter;
import org.apache.tuscany.sca.databinding.jaxb.JAXBWrapperException;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBPropertyDescriptor
implements Comparable<JAXBPropertyDescriptor> {
    PropertyDescriptor descriptor;
    QName xmlName = null;
    int index;

    JAXBPropertyDescriptor(PropertyDescriptor descriptor, QName xmlName, int index) {
        this.descriptor = descriptor;
        this.xmlName = xmlName;
    }

    JAXBPropertyDescriptor(PropertyDescriptor descriptor, String xmlName, int index) {
        this.descriptor = descriptor;
        this.xmlName = new QName("", xmlName);
    }

    @Override
    public int compareTo(JAXBPropertyDescriptor o) {
        return this.index - o.index;
    }

    public String getXmlName() {
        return this.xmlName.getLocalPart();
    }

    public QName getXmlQName() {
        return this.xmlName;
    }

    public Class<?> getPropertyType() {
        return this.descriptor.getPropertyType();
    }

    public String getPropertyName() {
        return this.descriptor.getName();
    }

    public Object get(Object targetBean) throws InvocationTargetException, IllegalAccessException {
        String propertyName;
        Method method = this.descriptor.getReadMethod();
        if (method == null && this.descriptor.getPropertyType() == Boolean.class && (propertyName = this.descriptor.getName()) != null) {
            String methodName = "is";
            methodName = methodName + (propertyName.length() > 0 ? propertyName.substring(0, 1).toUpperCase() : "");
            methodName = methodName + (propertyName.length() > 1 ? propertyName.substring(1) : "");
            try {
                method = targetBean.getClass().getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (method == null) {
            throw new ServiceRuntimeException("No getter is found");
        }
        Object ret = method.invoke(targetBean, new Object[0]);
        if (method.getReturnType() == JAXBElement.class) {
            ret = ((JAXBElement)ret).getValue();
        }
        return ret;
    }

    public void set(Object targetBean, Object propValue) throws InvocationTargetException, IllegalAccessException, JAXBWrapperException {
        Method writeMethod = null;
        if (propValue == null) {
            return;
        }
        writeMethod = this.descriptor.getWriteMethod();
        if (this.descriptor instanceof IndexedPropertyDescriptor) {
            this.setIndexedArray(targetBean, propValue, writeMethod);
        } else if (writeMethod == null) {
            this.setList(targetBean, propValue);
        } else if (this.descriptor.getPropertyType() == JAXBElement.class) {
            if (propValue != null) {
                Class<?> clazz = propValue.getClass();
                JAXBElement element = new JAXBElement(this.xmlName, clazz, propValue);
                this.setAtomic(targetBean, element, writeMethod);
            }
        } else {
            this.setAtomic(targetBean, propValue, writeMethod);
        }
    }

    private void setAtomic(Object targetBean, Object propValue, Method writeMethod) throws InvocationTargetException, IllegalAccessException, JAXBWrapperException {
        if (propValue != null) {
            Object[] SINGLE_PARAM = new Object[]{propValue};
            writeMethod.invoke(targetBean, SINGLE_PARAM);
        } else {
            Class<?> paramType;
            Class<?>[] paramTypes = writeMethod.getParameterTypes();
            if (paramTypes != null && paramTypes.length == 1 && (paramType = paramTypes[0]).isPrimitive() && propValue == null) {
                return;
            }
        }
    }

    private void setIndexedArray(Object targetBean, Object propValue, Method writeMethod) throws InvocationTargetException, IllegalAccessException, JAXBWrapperException {
        Class<?> paramType = writeMethod.getParameterTypes()[0];
        Object value = JAXBPropertyDescriptor.asArray(propValue, paramType);
        Object[] SINGLE_PARAM = new Object[]{value};
        writeMethod.invoke(targetBean, SINGLE_PARAM);
    }

    private void setList(Object targetBean, Object propValue) throws InvocationTargetException, IllegalAccessException, JAXBWrapperException {
        Collection value = JAXBPropertyDescriptor.asCollection(propValue, this.descriptor.getPropertyType());
        Collection collection = (Collection)this.get(targetBean);
        collection.clear();
        if (propValue != null) {
            collection.addAll(value);
        }
    }

    private static Collection asCollection(Object propValue, Class<?> destType) {
        if (DataConverter.isConvertable(propValue, destType)) {
            return (Collection)DataConverter.convert(propValue, destType);
        }
        String objectClass = propValue == null ? "null" : propValue.getClass().getName();
        throw new ServiceRuntimeException("Cannot convert " + objectClass);
    }

    private static Object asArray(Object propValue, Class<?> destType) {
        if (DataConverter.isConvertable(propValue, destType)) {
            return DataConverter.convert(propValue, destType);
        }
        String objectClass = propValue == null ? "null" : propValue.getClass().getName();
        throw new ServiceRuntimeException("Cannot convert " + objectClass);
    }

    public String toString() {
        String value = "PropertyDescriptorPlus[";
        value = value + " name=" + this.getPropertyName();
        value = value + " type=" + this.getPropertyType().getName();
        value = value + " propertyDecriptor=" + this.descriptor;
        return value + "]";
    }
}

