/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb.axiom;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

public class AxiomHelper {
    private static final String DEFAULT_PREFIX = "_ns_";

    private AxiomHelper() {
    }

    public static void completeAndClose(OMElement om) {
        OMXMLParserWrapper builder = om.getBuilder();
        if (builder != null) {
            OMElement document;
            if (builder instanceof StAXBuilder) {
                ((StAXBuilder)builder).releaseParserOnClose(true);
            }
            if ((document = builder.getDocumentElement()) != null) {
                document.build();
            }
        }
        if (builder instanceof StAXBuilder) {
            ((StAXBuilder)builder).close();
        }
    }

    public static void closeImmediately(OMElement om) {
        OMXMLParserWrapper builder = om.getBuilder();
        if (builder != null && builder instanceof StAXBuilder) {
            ((StAXBuilder)builder).releaseParserOnClose(true);
            ((StAXBuilder)builder).close();
        }
    }

    public static void adjustElementName(TransformationContext context, OMElement element) {
        if (context != null) {
            Object logical;
            DataType dataType = context.getTargetDataType();
            Object v0 = logical = dataType == null ? null : dataType.getLogical();
            if (!(logical instanceof XMLType)) {
                return;
            }
            XMLType xmlType = logical;
            if (xmlType.isElement() && !xmlType.getElementName().equals(element.getQName())) {
                OMFactory factory = OMAbstractFactory.getOMFactory();
                QName name = xmlType.getElementName();
                OMNamespace namespace = factory.createOMNamespace(name.getNamespaceURI(), name.getPrefix());
                element.setNamespace(namespace);
                element.setLocalName(name.getLocalPart());
            }
        }
    }

    public static OMElement createOMElement(OMFactory factory, QName element) {
        String localName = element.getLocalPart();
        OMNamespace ns = AxiomHelper.createOMNamespace(factory, element);
        return factory.createOMElement(localName, ns);
    }

    public static OMElement createOMElement(OMFactory factory, QName element, OMDataSource dataSource) {
        String localName = element.getLocalPart();
        OMNamespace ns = AxiomHelper.createOMNamespace(factory, element);
        return factory.createOMElement(dataSource, localName, ns);
    }

    public static OMNamespace createOMNamespace(OMFactory factory, QName name) {
        String namespaceURI = name.getNamespaceURI();
        String prefix = name.getPrefix();
        OMNamespace ns = null;
        if (prefix.length() == 0) {
            prefix = DEFAULT_PREFIX;
        }
        ns = factory.createOMNamespace(namespaceURI, prefix);
        return ns;
    }
}

