/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb.axiom;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.tuscany.sca.databinding.jaxb.axiom.JAXBDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBCustomBuilder
implements CustomBuilder {
    private Class<?> type;
    private JAXBContext jaxbContext;
    private Unmarshaller unmarshaller;
    public static final String URI_NS_SOAP_1_1_ENVELOPE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String URI_NS_SOAP_1_2_ENVELOPE = "http://www.w3.org/2003/05/soap-envelope";

    public JAXBCustomBuilder(JAXBContext context, Class<?> type, Unmarshaller unmarshaller) {
        this.type = type;
        this.jaxbContext = context;
        this.unmarshaller = unmarshaller;
    }

    public OMElement create(String namespace, String localPart, OMContainer parent, XMLStreamReader reader, OMFactory factory) throws OMException {
        if (!this.shouldUnmarshal(namespace, localPart)) {
            return null;
        }
        try {
            OMNamespace ns = factory.createOMNamespace(namespace, reader.getPrefix());
            JAXBElement jaxb = this.unmarshaller.unmarshal(reader, this.type);
            JAXBDataSource ds = new JAXBDataSource(jaxb, this.jaxbContext);
            OMSourcedElement omse = factory.createOMElement((OMDataSource)ds, localPart, ns);
            parent.addChild((OMNode)omse);
            return omse;
        }
        catch (JAXBException e) {
            throw new OMException((Throwable)e);
        }
    }

    private boolean shouldUnmarshal(String namespace, String localPart) {
        if (localPart == null || namespace == null || namespace.length() == 0 || URI_NS_SOAP_1_1_ENVELOPE.equals(namespace) || URI_NS_SOAP_1_2_ENVELOPE.equals(namespace)) {
            return false;
        }
        return !localPart.equals("EncryptedData");
    }
}

