/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb.axiom;

import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.ds.OMDataSourceExtBase;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;

public class JAXBDataSource
extends OMDataSourceExtBase {
    private JAXBContext context;
    private Object element;

    public JAXBDataSource(Object element, JAXBContext context) {
        this.element = element;
        this.context = context;
    }

    private Marshaller getMarshaller() throws JAXBException {
        return JAXBContextHelper.getMarshaller(this.context);
    }

    private void releaseMarshaller(Marshaller marshaller) {
        JAXBContextHelper.releaseJAXBMarshaller(this.context, marshaller);
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        StringWriter writer = new StringWriter();
        this.serialize(writer, new OMOutputFormat());
        StringReader reader = new StringReader(writer.toString());
        return StAXUtils.createXMLStreamReader((Reader)reader);
    }

    private static OutputStream getOutputStream(XMLStreamWriter writer) throws XMLStreamException {
        if (writer.getClass() == MTOMXMLStreamWriter.class) {
            return ((MTOMXMLStreamWriter)writer).getOutputStream();
        }
        try {
            Method method = writer.getClass().getMethod("getOutputStream", new Class[0]);
            return (OutputStream)method.invoke((Object)writer, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void serialize(final XMLStreamWriter xmlWriter) throws XMLStreamException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    Marshaller marshaller = null;
                    try {
                        marshaller = JAXBDataSource.this.getMarshaller();
                        OutputStream os = JAXBDataSource.getOutputStream(xmlWriter);
                        if (os != null) {
                            marshaller.marshal(JAXBDataSource.this.element, os);
                        } else {
                            marshaller.marshal(JAXBDataSource.this.element, xmlWriter);
                        }
                    }
                    finally {
                        JAXBDataSource.this.releaseMarshaller(marshaller);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new XMLStreamException(e.getException());
        }
    }

    public void serialize(final OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    Marshaller marshaller = null;
                    try {
                        marshaller = JAXBDataSource.this.getMarshaller();
                        marshaller.marshal(JAXBDataSource.this.element, output);
                    }
                    finally {
                        JAXBDataSource.this.releaseMarshaller(marshaller);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new XMLStreamException(e.getException());
        }
    }

    public void serialize(final Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    Marshaller marshaller = null;
                    try {
                        marshaller = JAXBDataSource.this.getMarshaller();
                        marshaller.marshal(JAXBDataSource.this.element, writer);
                    }
                    finally {
                        JAXBDataSource.this.releaseMarshaller(marshaller);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new XMLStreamException(e.getException());
        }
    }

    public Object getObject() {
        return this.element;
    }

    public void close() {
    }

    public OMDataSourceExt copy() {
        return new JAXBDataSource(this.element, this.context);
    }

    public byte[] getXMLBytes(final String encoding) throws UnsupportedEncodingException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public byte[] run() throws JAXBException, XMLStreamException, UnsupportedEncodingException {
                    byte[] byArray;
                    Marshaller marshaller = null;
                    try {
                        StringWriter sw = new StringWriter();
                        marshaller = JAXBDataSource.this.getMarshaller();
                        marshaller.marshal(JAXBDataSource.this.element, (Writer)sw);
                        byArray = sw.toString().getBytes(encoding);
                    }
                    catch (Throwable throwable) {
                        JAXBDataSource.this.releaseMarshaller(marshaller);
                        throw throwable;
                    }
                    JAXBDataSource.this.releaseMarshaller(marshaller);
                    return byArray;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof UnsupportedEncodingException) {
                throw (UnsupportedEncodingException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public boolean isDestructiveWrite() {
        return false;
    }
}

