/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.json;

import com.metaparadigm.jsonrpc.JSONSerializer;
import com.metaparadigm.jsonrpc.SerializerState;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBean2JSON
extends BaseTransformer<Object, Object>
implements PullTransformer<Object, Object> {
    private JSONSerializer serializer = new JSONSerializer();

    public JavaBean2JSON() {
        try {
            this.serializer.registerDefaultSerializers();
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
        this.serializer.setMarshallClassHints(true);
        this.serializer.setMarshallNullAttributes(true);
    }

    @Override
    public String getSourceDataBinding() {
        return "java:complexType";
    }

    @Override
    protected Class<Object> getSourceType() {
        return Object.class;
    }

    @Override
    public String getTargetDataBinding() {
        return "JSON";
    }

    @Override
    protected Class<Object> getTargetType() {
        return Object.class;
    }

    public Object toJSON(Object source) throws Exception {
        if (source == null) {
            return JSONObject.NULL;
        }
        SerializerState state = new SerializerState();
        return this.serializer.marshall(state, source);
    }

    @Override
    public Object transform(Object source, TransformationContext context) {
        try {
            return this.toJSON(source);
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }
}

