/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.saxon;

import commonj.sdo.DataObject;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.helper.XMLHelper;
import javax.xml.transform.dom.DOMResult;
import net.sf.saxon.om.NodeInfo;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.impl.DOMHelper;
import org.apache.tuscany.sca.databinding.saxon.Node2NodeInfoTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObject2NodeInfoTransformer
extends BaseTransformer<DataObject, NodeInfo>
implements PullTransformer<DataObject, NodeInfo> {
    private Node2NodeInfoTransformer node2NodeInfoTransformer;

    public DataObject2NodeInfoTransformer(Node2NodeInfoTransformer node2NodeInfoTransformer) {
        this.node2NodeInfoTransformer = node2NodeInfoTransformer;
    }

    public DataObject2NodeInfoTransformer() {
        this.node2NodeInfoTransformer = new Node2NodeInfoTransformer();
    }

    @Override
    public NodeInfo transform(DataObject source, TransformationContext context) {
        XMLHelper helper = XMLHelper.INSTANCE;
        String name = null;
        name = source.getClass().getInterfaces().length > 0 ? source.getClass().getInterfaces()[0].getSimpleName() : source.getClass().getName();
        if (name.length() > 0) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1, name.length());
        }
        try {
            DOMResult domResult = new DOMResult(DOMHelper.newDocument());
            XMLDocument xmlDoc = helper.createDocument(source, null, name);
            helper.save(xmlDoc, domResult, null);
            return this.node2NodeInfoTransformer.transform(domResult.getNode(), context);
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    @Override
    protected Class<DataObject> getSourceType() {
        return DataObject.class;
    }

    @Override
    protected Class<NodeInfo> getTargetType() {
        return NodeInfo.class;
    }

    @Override
    public int getWeight() {
        return 30 + this.node2NodeInfoTransformer.getWeight();
    }
}

