/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.saxon;

import java.lang.reflect.Array;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.saxon.NodeInfo2DataObjectTransformer;
import org.apache.tuscany.sca.databinding.saxon.collection.ItemList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemList2ObjectTransformer
extends BaseTransformer<ItemList, Object>
implements PullTransformer<ItemList, Object> {
    private NodeInfo2DataObjectTransformer nodeInfo2DataObjectTransformer = new NodeInfo2DataObjectTransformer();

    @Override
    protected Class<ItemList> getSourceType() {
        return ItemList.class;
    }

    @Override
    protected Class<Object> getTargetType() {
        return Object.class;
    }

    @Override
    public int getWeight() {
        return 30 + this.nodeInfo2DataObjectTransformer.getWeight();
    }

    @Override
    public Object transform(ItemList source, TransformationContext context) {
        if (source.size() == 0) {
            return null;
        }
        Class<?> targetType = context.getTargetDataType().getPhysical();
        if (targetType.isArray()) {
            int i = 0;
            Class<Object> componentClass = targetType.getComponentType();
            Object[] result = (Object[])Array.newInstance(componentClass, source.size());
            try {
                if (componentClass.isAssignableFrom(NodeInfo.class) || componentClass.isAssignableFrom(Value.class)) {
                    for (Item item : source) {
                        result[i++] = item;
                    }
                } else {
                    for (Item item : source) {
                        result[i] = item instanceof NodeInfo ? this.nodeInfo2DataObjectTransformer.transform((NodeInfo)item, context) : (item instanceof Value ? Value.convert((Item)item) : item);
                        ++i;
                    }
                }
            }
            catch (ArrayStoreException ex) {
                throw new TransformationException(ex);
            }
            catch (XPathException ex) {
                throw new TransformationException(ex);
            }
            return result;
        }
        Item item = (Item)source.iterator().next();
        if (item.getClass().isAssignableFrom(targetType)) {
            return item;
        }
        if (item instanceof NodeInfo) {
            return this.nodeInfo2DataObjectTransformer.transform((NodeInfo)item, context);
        }
        try {
            return Value.convert((Item)item);
        }
        catch (XPathException e) {
            throw new TransformationException(e);
        }
    }
}

