/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.saxon;

import commonj.sdo.DataObject;
import commonj.sdo.helper.XMLHelper;
import java.io.IOException;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.om.NodeInfo;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.saxon.NodeInfo2NodeTransformer;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInfo2DataObjectTransformer
extends BaseTransformer<NodeInfo, DataObject>
implements PullTransformer<NodeInfo, DataObject> {
    private NodeInfo2NodeTransformer nodeInfo2NodeTransformer;

    public NodeInfo2DataObjectTransformer(NodeInfo2NodeTransformer nodeInfo2NodeTransformer) {
        this.nodeInfo2NodeTransformer = nodeInfo2NodeTransformer;
    }

    public NodeInfo2DataObjectTransformer() {
        this.nodeInfo2NodeTransformer = new NodeInfo2NodeTransformer();
    }

    @Override
    protected Class<NodeInfo> getSourceType() {
        return NodeInfo.class;
    }

    @Override
    protected Class<DataObject> getTargetType() {
        return DataObject.class;
    }

    @Override
    public int getWeight() {
        return 30 + this.nodeInfo2NodeTransformer.getWeight();
    }

    @Override
    public DataObject transform(NodeInfo source, TransformationContext context) {
        Document doc = (Document)this.nodeInfo2NodeTransformer.transform(source, context);
        return this.produceResult(doc);
    }

    private DataObject produceResult(Document doc) {
        try {
            DataObject resultingObject = XMLHelper.INSTANCE.load(new DOMSource(doc), doc.getDocumentURI(), null).getRootObject();
            return resultingObject;
        }
        catch (IOException e) {
            throw new TransformationException(e);
        }
    }
}

