/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.saxon;

import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.om.NodeInfo;
import org.apache.tuscany.sca.databinding.DataPipe;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.saxon.SaxonDataBindingHelper;
import org.apache.tuscany.sca.databinding.xml.SAX2DOMPipe;
import org.apache.tuscany.sca.databinding.xml.StAX2SAXAdapter;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamReader2NodeInfoTransformer
extends BaseTransformer<XMLStreamReader, NodeInfo>
implements PullTransformer<XMLStreamReader, NodeInfo> {
    private StAX2SAXAdapter stax2sax = new StAX2SAXAdapter(false);
    private SAX2DOMPipe sax2dom = new SAX2DOMPipe();

    @Override
    public NodeInfo transform(XMLStreamReader source, TransformationContext context) {
        Configuration configuration = SaxonDataBindingHelper.CURR_EXECUTING_CONFIG;
        if (configuration == null) {
            configuration = new Configuration();
        }
        NodeInfo docInfo = null;
        try {
            DataPipe<ContentHandler, Node> pipe = this.sax2dom.newInstance();
            this.stax2sax.parse(source, pipe.getSink());
            Node node = pipe.getResult();
            source.close();
            docInfo = Builder.build((Source)new DOMSource(node), null, (Configuration)configuration);
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
        return docInfo;
    }

    @Override
    protected Class<XMLStreamReader> getSourceType() {
        return XMLStreamReader.class;
    }

    @Override
    protected Class<NodeInfo> getTargetType() {
        return NodeInfo.class;
    }

    @Override
    public int getWeight() {
        return 10;
    }
}

