/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo;

import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XSDHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.databinding.sdo.ImportSDO;
import org.apache.tuscany.sca.databinding.sdo.SDOContextHelper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ImportSDOProcessor
implements StAXArtifactProcessor<ImportSDO> {
    private ContributionFactory contributionFactory;
    private Monitor monitor;

    public ImportSDOProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "databinding-sdo-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "databinding-sdo-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    public QName getXMLType() {
        return ImportSDO.IMPORT_SDO;
    }

    @Override
    public ImportSDO read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String location;
        assert (ImportSDO.IMPORT_SDO.equals(reader.getName()));
        ImportSDO importSDO = new ImportSDO(SDOContextHelper.getDefaultHelperContext());
        String factoryName = reader.getAttributeValue(null, "factory");
        if (factoryName != null) {
            importSDO.setFactoryClassName(factoryName);
        }
        if ((location = reader.getAttributeValue(null, "location")) != null) {
            importSDO.setSchemaLocation(location);
        }
        while (reader.hasNext() && (reader.next() != 2 || !ImportSDO.IMPORT_SDO.equals(reader.getName()))) {
        }
        return importSDO;
    }

    private void importFactory(ImportSDO importSDO, ModelResolver resolver) throws ContributionResolveException {
        String factoryName = importSDO.getFactoryClassName();
        if (factoryName != null) {
            ClassReference reference = new ClassReference(factoryName);
            ClassReference resolved = resolver.resolveModel(ClassReference.class, reference);
            if (resolved != null && !resolved.isUnresolved()) {
                try {
                    Class<?> factoryClass = resolved.getJavaClass();
                    ImportSDOProcessor.register(factoryClass, importSDO.getHelperContext());
                    importSDO.setUnresolved(false);
                }
                catch (Exception e) {
                    ContributionResolveException ce = new ContributionResolveException(e);
                    this.error("ContributionResolveException", (Object)resolver, ce);
                }
            } else {
                this.error("FailToResolveClass", (Object)resolver, factoryName);
            }
        }
    }

    private static void register(Class factoryClass, HelperContext helperContext) throws Exception {
        Field field = factoryClass.getField("INSTANCE");
        Object factory = field.get(null);
        Method method = factory.getClass().getMethod("register", HelperContext.class);
        method.invoke(factory, helperContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importWSDL(ImportSDO importSDO, ModelResolver resolver) throws ContributionResolveException {
        block8: {
            String location = importSDO.getSchemaLocation();
            if (location != null) {
                try {
                    Artifact artifact = this.contributionFactory.createArtifact();
                    artifact.setURI(location);
                    artifact = resolver.resolveModel(Artifact.class, artifact);
                    if (artifact.getLocation() != null) {
                        String wsdlURL = artifact.getLocation();
                        URLConnection connection = new URL(wsdlURL).openConnection();
                        connection.setUseCaches(false);
                        InputStream xsdInputStream = connection.getInputStream();
                        try {
                            XSDHelper xsdHelper = importSDO.getHelperContext().getXSDHelper();
                            xsdHelper.define(xsdInputStream, wsdlURL);
                        }
                        finally {
                            xsdInputStream.close();
                        }
                        importSDO.setUnresolved(false);
                        break block8;
                    }
                    this.error("FailToResolveLocation", (Object)resolver, location);
                }
                catch (IOException e) {
                    ContributionResolveException ce = new ContributionResolveException(e);
                    this.error("ContributionResolveException", (Object)resolver, ce);
                }
            }
        }
    }

    @Override
    public QName getArtifactType() {
        return ImportSDO.IMPORT_SDO;
    }

    @Override
    public void write(ImportSDO model, XMLStreamWriter outputSource) throws ContributionWriteException {
    }

    @Override
    public Class<ImportSDO> getModelType() {
        return ImportSDO.class;
    }

    @Override
    public void resolve(ImportSDO importSDO, ModelResolver resolver) throws ContributionResolveException {
        this.importFactory(importSDO, resolver);
        this.importWSDL(importSDO, resolver);
        if (!importSDO.isUnresolved()) {
            resolver.addModel(importSDO);
        }
    }
}

