/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.impl.HelperProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.sdo.SDODataBinding;
import org.apache.tuscany.sca.databinding.util.DataTypeHelper;
import org.apache.tuscany.sca.databinding.util.LRUCache;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sdo.api.SDOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SDOContextHelper {
    private static final LRUCache<Object, HelperContext> cache = new LRUCache(1024);

    private SDOContextHelper() {
    }

    public static HelperContext getHelperContext(TransformationContext context, boolean source) {
        Operation op;
        if (context == null) {
            return SDOContextHelper.getDefaultHelperContext();
        }
        HelperContext helperContext = null;
        Operation operation = op = source ? context.getSourceOperation() : context.getTargetOperation();
        if (op == null) {
            DataType dt = source ? context.getSourceDataType() : context.getTargetDataType();
            helperContext = dt.getMetaData(HelperContext.class);
            if (helperContext != null) {
                return helperContext;
            }
            helperContext = SDOUtil.createHelperContext();
            boolean found = SDOContextHelper.register(helperContext, dt);
            if (!found) {
                helperContext = SDOContextHelper.getDefaultHelperContext();
            }
            dt.setMetaData(HelperContext.class, helperContext);
            return helperContext;
        }
        return SDOContextHelper.getHelperContext(op);
    }

    public static HelperContext getHelperContext(Operation op) {
        if (op == null) {
            return SDOContextHelper.getDefaultHelperContext();
        }
        HelperContext helperContext = op.getInputType().getMetaData(HelperContext.class);
        if (helperContext != null) {
            return helperContext;
        }
        helperContext = SDOContextHelper.getDefaultHelperContext();
        op.getInputType().setMetaData(HelperContext.class, helperContext);
        return helperContext;
    }

    private static boolean register(HelperContext helperContext, DataType dataType) {
        if (dataType == null) {
            return false;
        }
        Set<Class<?>> classes = DataTypeHelper.findClasses(dataType);
        boolean found = false;
        for (Class<?> cls : classes) {
            found = SDOContextHelper.register(helperContext, dataType.getPhysical()) || found;
        }
        return found;
    }

    public static boolean register(HelperContext helperContext, Class javaType) {
        if (javaType == null || DataObject.class == javaType) {
            return false;
        }
        try {
            Type type = helperContext.getTypeHelper().getType(javaType);
            return SDOContextHelper.register(helperContext, type);
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    public static boolean register(HelperContext helperContext, Type type) {
        if (type != null && !type.isDataType()) {
            try {
                Method method = type.getClass().getMethod("getEPackage", new Class[0]);
                Object factory = method.invoke((Object)type, new Object[0]);
                method = factory.getClass().getMethod("register", HelperContext.class);
                method.invoke(factory, helperContext);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static HelperContext getDefaultHelperContext() {
        return HelperProvider.getDefaultContext();
    }

    public static QName getElement(TransformationContext context) {
        XMLType xmlType;
        QName element;
        if (context == null) {
            return SDODataBinding.ROOT_ELEMENT;
        }
        DataType dataType = context.getTargetDataType();
        Object logical = dataType.getLogical();
        QName elementName = null;
        if (logical instanceof XMLType && (element = (xmlType = (XMLType)logical).getElementName()) != null) {
            elementName = element;
        }
        if (elementName == null && (logical = (dataType = context.getSourceDataType()).getLogical()) instanceof XMLType && (element = (xmlType = (XMLType)logical).getElementName()) != null) {
            elementName = element;
        }
        if (elementName != null) {
            return elementName;
        }
        return SDODataBinding.ROOT_ELEMENT;
    }

    public static String generateSchema(HelperContext context, Class<?>[] classes) {
        TypeHelper typeHelper = context.getTypeHelper();
        ArrayList<Type> types = new ArrayList<Type>();
        for (Class<?> cls : classes) {
            Type type = typeHelper.getType(cls);
            if (type == null) continue;
            types.add(type);
        }
        return SDOContextHelper.generateSchema(context, types);
    }

    public static String generateSchema(HelperContext context, List<Type> types) {
        return context.getXSDHelper().generate(types);
    }
}

