/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo.xml;

import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XSDHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.sdo.SDOTypes;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.tuscany.sdo.api.SDOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOTypesModelResolver
implements ModelResolver {
    private Contribution contribution;
    private HelperContext helperContext;
    private List<SDOTypes> sdoTypes = new ArrayList<SDOTypes>();
    private ContributionFactory contributionFactory;
    private XSDFactory xsdFactory;
    private Monitor monitor;

    public SDOTypesModelResolver(Contribution contribution, ExtensionPointRegistry registry) {
        ModelFactoryExtensionPoint modelFactories = registry.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.xsdFactory = modelFactories.getFactory(XSDFactory.class);
        this.monitor = SDOTypesModelResolver.createMonitor(registry);
        this.contribution = contribution;
    }

    private static Monitor createMonitor(ExtensionPointRegistry extensionPoints) {
        MonitorFactory monitorFactory;
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        if (utilities != null && (monitorFactory = utilities.getUtility(MonitorFactory.class)) != null) {
            return monitorFactory.createMonitor();
        }
        return null;
    }

    @Override
    public void addModel(Object resolved) {
        if (this.helperContext == null) {
            this.helperContext = SDOUtil.createHelperContext();
        }
        SDOTypes types = (SDOTypes)resolved;
        try {
            this.loadSDOTypes(types, this.contribution.getModelResolver());
        }
        catch (ContributionResolveException e) {
            e.printStackTrace();
        }
        this.sdoTypes.add(types);
    }

    @Override
    public Object removeModel(Object resolved) {
        SDOTypes types = (SDOTypes)resolved;
        return this.sdoTypes.remove(types);
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        SDOTypes types = (SDOTypes)unresolved;
        String ns = types.getNamespace();
        for (SDOTypes t : this.sdoTypes) {
            if (!t.getNamespace().equals(types.getNamespace())) continue;
            try {
                this.loadSDOTypes(types, this.contribution.getModelResolver());
            }
            catch (ContributionResolveException e) {
                e.printStackTrace();
            }
            return (T)t;
        }
        return (T)types;
    }

    private static void register(Class<?> factoryClass, HelperContext helperContext) throws Exception {
        Field field = factoryClass.getField("INSTANCE");
        Object factory = field.get(null);
        Method method = factory.getClass().getMethod("register", HelperContext.class);
        method.invoke(factory, helperContext);
    }

    private void defineFromFactory(SDOTypes importSDO, ModelResolver resolver) throws ContributionResolveException {
        String factoryName = importSDO.getFactory();
        if (factoryName != null) {
            ClassReference reference = new ClassReference(factoryName);
            ClassReference resolved = resolver.resolveModel(ClassReference.class, reference);
            if (resolved != null && !resolved.isUnresolved()) {
                try {
                    Class<?> factoryClass = resolved.getJavaClass();
                    Field field = factoryClass.getField("NAMESPACE_URI");
                    importSDO.setNamespace((String)field.get(null));
                    SDOTypesModelResolver.register(factoryClass, this.helperContext);
                    importSDO.setUnresolved(false);
                }
                catch (Exception e) {
                    ContributionResolveException ce = new ContributionResolveException(e);
                    this.error("ContributionResolveException", (Object)resolver, ce);
                }
            } else {
                this.error("FailToResolveClass", (Object)resolver, factoryName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defineFromXSD(SDOTypes importSDO, ModelResolver resolver) throws ContributionResolveException {
        block12: {
            String location = importSDO.getSchemaLocation();
            if (location != null) {
                try {
                    Artifact artifact = this.contributionFactory.createArtifact();
                    artifact.setURI(location);
                    artifact = resolver.resolveModel(Artifact.class, artifact);
                    if (artifact.getLocation() != null) {
                        String wsdlURL = artifact.getLocation();
                        URLConnection connection = new URL(wsdlURL).openConnection();
                        connection.setUseCaches(false);
                        InputStream xsdInputStream = connection.getInputStream();
                        try {
                            XSDHelper xsdHelper = this.helperContext.getXSDHelper();
                            List sdoTypes = xsdHelper.define(xsdInputStream, wsdlURL);
                            Iterator i$ = sdoTypes.iterator();
                            if (i$.hasNext()) {
                                Type t = (Type)i$.next();
                                importSDO.setNamespace(t.getURI());
                            }
                            importSDO.getTypes().addAll(sdoTypes);
                        }
                        finally {
                            xsdInputStream.close();
                        }
                        importSDO.setUnresolved(false);
                        break block12;
                    }
                    this.error("FailToResolveLocation", (Object)resolver, location);
                }
                catch (IOException e) {
                    ContributionResolveException ce = new ContributionResolveException(e);
                    this.error("ContributionResolveException", (Object)resolver, ce);
                }
            } else {
                String ns = importSDO.getNamespace();
                if (ns != null) {
                    XSDefinition xsd = this.xsdFactory.createXSDefinition();
                    xsd.setUnresolved(true);
                    xsd.setNamespace(ns);
                    xsd = resolver.resolveModel(XSDefinition.class, xsd);
                    if (!xsd.isUnresolved()) {
                        XSDHelper xsdHelper = this.helperContext.getXSDHelper();
                        xsdHelper.define(xsd.getLocation().toString());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSDOTypes(SDOTypes types, ModelResolver resolver) throws ContributionResolveException {
        SDOTypes sDOTypes = types;
        synchronized (sDOTypes) {
            if (types.isUnresolved()) {
                this.defineFromFactory(types, resolver);
                this.defineFromXSD(types, resolver);
                types.setUnresolved(false);
            }
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "databinding-sdo-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "databinding-sdo-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }
}

