/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.databinding.sdo.SDOTypes;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOTypesProcessor
implements StAXArtifactProcessor<SDOTypes> {
    public SDOTypesProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
    }

    public QName getXMLType() {
        return SDOTypes.SDO_TYPES;
    }

    @Override
    public SDOTypes read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String location;
        assert (SDOTypes.SDO_TYPES.equals(reader.getName()));
        SDOTypes sdoTypes = new SDOTypes();
        String factoryName = reader.getAttributeValue(null, "factory");
        if (factoryName != null) {
            sdoTypes.setFactory(factoryName);
        }
        if ((location = reader.getAttributeValue(null, "location")) != null) {
            sdoTypes.setSchemaLocation(location);
        }
        String ns = reader.getAttributeValue(null, "namespace");
        sdoTypes.setNamespace(ns);
        while (reader.hasNext() && (reader.next() != 2 || !SDOTypes.SDO_TYPES.equals(reader.getName()))) {
        }
        return sdoTypes;
    }

    @Override
    public QName getArtifactType() {
        return SDOTypes.SDO_TYPES;
    }

    @Override
    public void write(SDOTypes model, XMLStreamWriter writer) throws ContributionWriteException {
        try {
            writer.writeStartElement(SDOTypes.SDO_TYPES.getNamespaceURI(), SDOTypes.SDO_TYPES.getLocalPart());
            if (model.getNamespace() != null) {
                writer.writeAttribute("namespace", model.getNamespace());
            }
            if (model.getSchemaLocation() != null) {
                writer.writeAttribute("location", model.getSchemaLocation());
            }
            if (model.getFactory() != null) {
                writer.writeAttribute("factory", model.getFactory());
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new ContributionWriteException(e);
        }
    }

    @Override
    public Class<SDOTypes> getModelType() {
        return SDOTypes.class;
    }

    @Override
    public void resolve(SDOTypes types, ModelResolver resolver) throws ContributionResolveException {
        resolver.addModel(types);
    }
}

