/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo2om;

import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.tuscany.sca.databinding.sdo.SDODataBinding;
import org.apache.tuscany.sdo.api.SDOUtil;
import org.apache.tuscany.sdo.api.XMLStreamHelper;

public class SDODataSource
implements OMDataSource {
    private HelperContext helperContext;
    private XMLDocument sourceDocument;

    public SDODataSource(XMLDocument source, HelperContext helperContext) {
        this.sourceDocument = source;
        this.helperContext = helperContext;
    }

    public SDODataSource(DataObject obj, HelperContext helperContext) {
        this.helperContext = helperContext;
        this.sourceDocument = helperContext.getXMLHelper().createDocument(obj, SDODataBinding.ROOT_ELEMENT.getNamespaceURI(), SDODataBinding.ROOT_ELEMENT.getLocalPart());
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        XMLStreamHelper streamHelper = SDOUtil.createXMLStreamHelper(this.helperContext);
        return streamHelper.createXMLStreamReader(this.sourceDocument);
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        StreamingOMSerializer serializer = new StreamingOMSerializer();
        serializer.serialize(this.getReader(), xmlWriter);
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            this.helperContext.getXMLHelper().save(this.sourceDocument, output, null);
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            this.helperContext.getXMLHelper().save(this.sourceDocument, writer, null);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }
}

