/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;

public class DelegatingNamespaceContext
implements NamespaceContext {
    private static int count;
    private NamespaceContext parentNsContext;
    private FastStack<String> prefixStack = new FastStack();
    private FastStack<String> uriStack = new FastStack();

    public String generateUniquePrefix() {
        String prefix = "p" + count++;
        while (this.getNamespaceURI(prefix) != null) {
            prefix = "p" + count++;
        }
        return prefix;
    }

    public String getNamespaceURI(String prefix) {
        int index = this.prefixStack.search(prefix);
        if (index != -1) {
            return (String)this.uriStack.get(index);
        }
        if (this.parentNsContext != null) {
            return this.parentNsContext.getPrefix(prefix);
        }
        return null;
    }

    public NamespaceContext getParentNsContext() {
        return this.parentNsContext;
    }

    public String getPrefix(String uri) {
        int index = this.uriStack.search(uri);
        if (index != -1) {
            return (String)this.prefixStack.get(index);
        }
        if (this.parentNsContext != null) {
            return this.parentNsContext.getPrefix(uri);
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        String[] uris = this.uriStack.toArray((String[])new String[this.uriStack.size()]);
        ArrayList tempList = new ArrayList();
        for (int i = uris.length - 1; i >= 0; --i) {
            if (!uris[i].equals(uri)) continue;
            tempList.add(this.prefixStack.get(i));
        }
        return new WrappingIterator(tempList.iterator());
    }

    public void popNamespace() {
        this.prefixStack.pop();
        this.uriStack.pop();
    }

    public void pushNamespace(String prefix, String uri) {
        this.prefixStack.push(prefix);
        this.uriStack.push(uri);
    }

    public void setParentNsContext(NamespaceContext parentNsContext) {
        this.parentNsContext = parentNsContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FastStack<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 2130079159931574599L;

        public FastStack() {
        }

        public FastStack(int initialSize) {
            super(initialSize);
        }

        public boolean empty() {
            return this.isEmpty();
        }

        public T peek() throws EmptyStackException {
            int n = this.size();
            if (n <= 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(n - 1);
        }

        public T peek(int n) throws EmptyStackException {
            int m = this.size() - n - 1;
            if (m < 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(m);
        }

        public T pop() throws EmptyStackException {
            int n = this.size();
            if (n <= 0) {
                throw new EmptyStackException();
            }
            return (T)this.remove(n - 1);
        }

        public Object push(T item) {
            this.add(item);
            return item;
        }

        public int search(T object) {
            for (int i = this.size() - 1; i >= 0; --i) {
                Object current = this.get(i);
                if ((object != null || current != null) && (object == null || !object.equals(current))) continue;
                return i;
            }
            return -1;
        }

        public T get() {
            int size = this.size();
            if (size == 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(size - 1);
        }

        public T remove() {
            int size = this.size();
            if (size == 0) {
                throw new EmptyStackException();
            }
            return (T)this.remove(size - 1);
        }
    }

    private class WrappingIterator
    implements Iterator {
        private Iterator containedIterator;

        public WrappingIterator(Iterator containedIterator) {
            this.containedIterator = containedIterator;
        }

        public Iterator getContainedIterator() {
            return this.containedIterator;
        }

        public boolean hasNext() {
            return this.containedIterator.hasNext();
        }

        public Object next() {
            return this.containedIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void setContainedIterator(Iterator containedIterator) {
            this.containedIterator = containedIterator;
        }
    }
}

