/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tuscany.sca.databinding.impl.DOMHelper;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAX2DOM
implements ContentHandler,
LexicalHandler {
    public static final String EMPTYSTRING = "";
    public static final String XML_PREFIX = "xml";
    public static final String XMLNS_PREFIX = "xmlns";
    public static final String XMLNS_STRING = "xmlns:";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private Node root;
    private Document document;
    private Node nextSibling;
    private Stack<Node> nodeStk = new Stack();
    private List<String> namespaceDecls;
    private Node lastSibling;

    public SAX2DOM() throws ParserConfigurationException {
        this.document = DOMHelper.newDocument();
        this.root = this.document;
    }

    public SAX2DOM(Node root, Node nextSibling) throws ParserConfigurationException {
        this.root = root;
        if (root instanceof Document) {
            this.document = (Document)root;
        } else if (root != null) {
            this.document = root.getOwnerDocument();
        } else {
            this.document = DOMHelper.newDocument();
            this.root = this.document;
        }
        this.nextSibling = nextSibling;
    }

    public SAX2DOM(Node root) throws ParserConfigurationException {
        this(root, null);
    }

    public Node getDOM() {
        return this.root;
    }

    public void characters(char[] ch, int start, int length) {
        Node last = this.nodeStk.peek();
        if (last != this.document) {
            String text = new String(ch, start, length);
            if (this.lastSibling != null && this.lastSibling.getNodeType() == 3) {
                ((Text)this.lastSibling).appendData(text);
            } else {
                this.lastSibling = last == this.root && this.nextSibling != null ? last.insertBefore(this.document.createTextNode(text), this.nextSibling) : last.appendChild(this.document.createTextNode(text));
            }
        }
    }

    public void startDocument() {
        this.nodeStk.push(this.root);
    }

    public void endDocument() {
        this.nodeStk.pop();
    }

    public void startElement(String namespace, String localName, String qName, Attributes attrs) {
        int i;
        Element tmp = this.document.createElementNS(namespace, qName);
        if (this.namespaceDecls != null) {
            int nDecls = this.namespaceDecls.size();
            for (i = 0; i < nDecls; ++i) {
                String prefix;
                if ((prefix = this.namespaceDecls.get(i++)) == null || prefix.equals(EMPTYSTRING)) {
                    tmp.setAttributeNS(XMLNS_URI, XMLNS_PREFIX, this.namespaceDecls.get(i));
                    continue;
                }
                tmp.setAttributeNS(XMLNS_URI, XMLNS_STRING + prefix, this.namespaceDecls.get(i));
            }
            this.namespaceDecls.clear();
        }
        int nattrs = attrs.getLength();
        for (i = 0; i < nattrs; ++i) {
            if (attrs.getLocalName(i) == null) {
                tmp.setAttribute(attrs.getQName(i), attrs.getValue(i));
                continue;
            }
            tmp.setAttributeNS(attrs.getURI(i), attrs.getQName(i), attrs.getValue(i));
        }
        Node last = this.nodeStk.peek();
        if (last == this.root && this.nextSibling != null) {
            last.insertBefore(tmp, this.nextSibling);
        } else {
            last.appendChild(tmp);
        }
        this.nodeStk.push(tmp);
        this.lastSibling = null;
    }

    public void endElement(String namespace, String localName, String qName) {
        this.nodeStk.pop();
        this.lastSibling = null;
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (this.namespaceDecls == null) {
            this.namespaceDecls = new ArrayList<String>(2);
        }
        this.namespaceDecls.add(prefix);
        this.namespaceDecls.add(uri);
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
        Node last = this.nodeStk.peek();
        ProcessingInstruction pi = this.document.createProcessingInstruction(target, data);
        if (pi != null) {
            if (last == this.root && this.nextSibling != null) {
                last.insertBefore(pi, this.nextSibling);
            } else {
                last.appendChild(pi);
            }
            this.lastSibling = pi;
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) {
    }

    public void comment(char[] ch, int start, int length) {
        Node last = this.nodeStk.peek();
        Comment comment = this.document.createComment(new String(ch, start, length));
        if (comment != null) {
            if (last == this.root && this.nextSibling != null) {
                last.insertBefore(comment, this.nextSibling);
            } else {
                last.appendChild(comment);
            }
            this.lastSibling = comment;
        }
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void startEntity(String name) {
    }

    public void endDTD() {
    }

    public void endEntity(String name) {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }
}

