/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLStreamSerializer
implements XMLStreamConstants {
    public static final String NAMESPACE_PREFIX = "ns";
    private static int namespaceSuffix;
    private int depth;

    private String generateUniquePrefix(NamespaceContext nsCtxt) {
        String prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        while (nsCtxt.getNamespaceURI(prefix) != null) {
            prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        }
        return prefix;
    }

    public void serialize(XMLStreamReader node, XMLStreamWriter writer) throws XMLStreamException {
        this.serializeNode(node, writer);
    }

    protected void serializeAttributes(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String prefix = reader.getAttributePrefix(i);
            String namespaceName = reader.getAttributeNamespace(i);
            if (namespaceName == null) {
                namespaceName = "";
            }
            String writerPrefix = writer.getPrefix(namespaceName);
            if (!"".equals(namespaceName)) {
                if (writerPrefix != null && (prefix == null || prefix.equals(""))) {
                    writer.writeAttribute(writerPrefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    continue;
                }
                if (prefix != null && !"".equals(prefix) && !prefix.equals(writerPrefix)) {
                    writer.writeNamespace(prefix, namespaceName);
                    writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    continue;
                }
                if (prefix == null || prefix.equals("")) {
                    prefix = this.generateUniquePrefix(writer.getNamespaceContext());
                    writer.writeNamespace(prefix, namespaceName);
                    writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    continue;
                }
                writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    protected void serializeCData(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCData(reader.getText());
    }

    protected void serializeComment(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment(reader.getText());
    }

    protected void serializeElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String prefix = reader.getPrefix();
        String nameSpaceName = reader.getNamespaceURI();
        if (nameSpaceName != null) {
            String writerPrefix = writer.getPrefix(nameSpaceName);
            if (writerPrefix != null) {
                writer.writeStartElement(nameSpaceName, reader.getLocalName());
            } else if (prefix != null) {
                writer.writeStartElement(prefix, reader.getLocalName(), nameSpaceName);
                writer.writeNamespace(prefix, nameSpaceName);
            } else {
                writer.setDefaultNamespace(nameSpaceName);
                writer.writeStartElement(nameSpaceName, reader.getLocalName());
                writer.writeDefaultNamespace(nameSpaceName);
            }
        } else {
            writer.writeStartElement(reader.getLocalName());
        }
        int count = reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String namespacePrefix = reader.getNamespacePrefix(i);
            this.serializeNamespace(namespacePrefix, reader.getNamespaceURI(i), writer);
        }
        this.serializeAttributes(reader, writer);
    }

    protected void serializeEndElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }

    private void serializeNamespace(String prefix, String uri, XMLStreamWriter writer) throws XMLStreamException {
        String prefix1 = writer.getPrefix(uri);
        if (prefix1 == null) {
            writer.writeNamespace(prefix, uri);
        }
    }

    protected void serializeNode(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        while (true) {
            int event;
            if ((event = reader.getEventType()) == 1) {
                this.serializeElement(reader, writer);
                ++this.depth;
            } else if (event == 10) {
                this.serializeAttributes(reader, writer);
            } else if (event == 4) {
                this.serializeText(reader, writer);
            } else if (event == 5) {
                this.serializeComment(reader, writer);
            } else if (event == 12) {
                this.serializeCData(reader, writer);
            } else if (event == 2) {
                this.serializeEndElement(writer);
                --this.depth;
            } else if (event == 7) {
                ++this.depth;
                writer.writeStartDocument();
            } else if (event == 8) {
                if (this.depth != 0) {
                    --this.depth;
                }
                writer.writeEndDocument();
            }
            if (this.depth == 0 || !reader.hasNext()) break;
            reader.next();
        }
    }

    protected void serializeText(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(reader.getText());
    }
}

