/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xmlbeans;

import java.lang.reflect.Field;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.impl.BaseDataBinding;
import org.apache.tuscany.sca.databinding.xmlbeans.XMLBeansWrapperHandler;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.osoa.sca.ServiceRuntimeException;

public class XMLBeansDataBinding
extends BaseDataBinding {
    public static final String NAME = XmlObject.class.getName();
    public static final String[] ALIASES = new String[]{"xmlbeans"};

    public XMLBeansDataBinding() {
        super(NAME, XmlObject.class);
    }

    public WrapperHandler getWrapperHandler() {
        return new XMLBeansWrapperHandler();
    }

    public boolean introspect(DataType type, Operation operation) {
        if (XmlObject.class.isAssignableFrom(type.getPhysical())) {
            Class<?> cls = type.getPhysical();
            SchemaType schemaType = null;
            try {
                Field f = cls.getField("type");
                schemaType = (SchemaType)f.get(null);
            }
            catch (Throwable e) {
                throw new ServiceRuntimeException(e);
            }
            QName typeName = schemaType.getName();
            Object logical = type.getLogical();
            QName elementName = null;
            if (logical instanceof XMLType) {
                elementName = ((XMLType)logical).getElementName();
            }
            type.setLogical(new XMLType(elementName, typeName));
            type.setMetaData(SchemaType.class, schemaType);
            return true;
        }
        return false;
    }

    public Object copy(Object object, DataType dataType, Operation operation) {
        return ((XmlObject)object).copy();
    }
}

