/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xmlbeans;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBeansWrapperHandler
implements WrapperHandler<XmlObject> {
    @Override
    public XmlObject create(Operation operation, boolean input) {
        WrapperInfo inputWrapperInfo = operation.getInputWrapper();
        WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
        ElementInfo element = input ? inputWrapperInfo.getWrapperElement() : outputWrapperInfo.getWrapperElement();
        return null;
    }

    @Override
    public List getChildren(XmlObject wrapper, Operation operation, boolean input) {
        ArrayList<Object> children = new ArrayList<Object>();
        WrapperInfo inputWrapperInfo = operation.getInputWrapper();
        WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
        List<ElementInfo> childElements = input ? inputWrapperInfo.getChildElements() : outputWrapperInfo.getChildElements();
        for (ElementInfo e : childElements) {
            XmlObject[] objects = wrapper.selectChildren(e.getQName());
            if (objects == null || objects.length != 1) continue;
            if (objects[0] instanceof SimpleValue) {
                children.add(((SimpleValue)objects[0]).getObjectValue());
                continue;
            }
            children.add(objects[0]);
        }
        return children;
    }

    @Override
    public DataType getWrapperType(Operation operation, boolean input) {
        return null;
    }

    @Override
    public boolean isInstance(Object wrapper, Operation operation, boolean input) {
        WrapperInfo inputWrapperInfo = operation.getInputWrapper();
        WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
        ElementInfo element = input ? inputWrapperInfo.getWrapperElement() : outputWrapperInfo.getWrapperElement();
        return true;
    }

    @Override
    public void setChildren(XmlObject wrapper, Object[] childObjects, Operation operation, boolean input) {
        WrapperInfo inputWrapperInfo = operation.getInputWrapper();
        WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
        List<ElementInfo> childElements = input ? inputWrapperInfo.getChildElements() : outputWrapperInfo.getChildElements();
        int i = 0;
        for (ElementInfo c : childElements) {
            SchemaProperty property = wrapper.schemaType().getElementProperty(c.getQName());
            String prop = property.getJavaPropertyName();
            try {
                Method setter = wrapper.schemaType().getJavaClass().getMethod("set" + prop, property.getType().getJavaClass());
                setter.invoke((Object)wrapper, childObjects[i++]);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

