/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.definitions.util;

import java.net.URI;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;

public class SCADefinitionsUtil {
    public static void stripDuplicates(SCADefinitions scaDefns) {
        HashMap<QName, Intent> definedIntents = new HashMap<QName, Intent>();
        for (Intent intent : scaDefns.getPolicyIntents()) {
            definedIntents.put(intent.getName(), intent);
        }
        HashMap<QName, PolicySet> definedPolicySets = new HashMap<QName, PolicySet>();
        for (PolicySet policySet : scaDefns.getPolicySets()) {
            definedPolicySets.put(policySet.getName(), policySet);
        }
        HashMap<QName, IntentAttachPointType> definedBindingTypes = new HashMap<QName, IntentAttachPointType>();
        for (IntentAttachPointType bindingType : scaDefns.getBindingTypes()) {
            definedBindingTypes.put(bindingType.getName(), bindingType);
        }
        HashMap<QName, IntentAttachPointType> definedImplTypes = new HashMap<QName, IntentAttachPointType>();
        for (IntentAttachPointType implType : scaDefns.getImplementationTypes()) {
            definedImplTypes.put(implType.getName(), implType);
        }
        scaDefns.getPolicyIntents().clear();
        scaDefns.getPolicyIntents().addAll(definedIntents.values());
        scaDefns.getPolicySets().clear();
        scaDefns.getPolicySets().addAll(definedPolicySets.values());
        scaDefns.getBindingTypes().clear();
        scaDefns.getBindingTypes().addAll(definedBindingTypes.values());
        scaDefns.getImplementationTypes().clear();
        scaDefns.getImplementationTypes().addAll(definedImplTypes.values());
    }

    public static void aggregateSCADefinitions(SCADefinitions source, SCADefinitions target) {
        target.getPolicyIntents().addAll(source.getPolicyIntents());
        target.getPolicySets().addAll(source.getPolicySets());
        target.getBindingTypes().addAll(source.getBindingTypes());
        target.getImplementationTypes().addAll(source.getImplementationTypes());
        target.getBindings().addAll(source.getBindings());
    }

    public static boolean isSCADefnsFile(URI uri) {
        int index = uri.toString().lastIndexOf("/");
        index = index != -1 ? index + 1 : 0;
        return uri.toString().substring(index).equals("definitions.xml");
    }
}

