/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.distribution;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.jar.JarFile;

public class CheckLocalRepository {
    public static void main(String[] args) {
        String repo = args[0];
        CheckLocalRepository.checkJarFile(repo);
        CheckLocalRepository.checkPomFile(repo);
        System.exit(0);
    }

    private static void checkJarFile(String repo) {
        try {
            JarFile jaxwsJar = new JarFile(repo + "/javax/xml/ws/jaxws-api/2.1/jaxws-api-2.1.jar");
            if (jaxwsJar.getEntry("javax/xml/ws/soap/Addressing.class") != null) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("===================================================================");
        System.out.println("ERROR: Incorrect version of jaxws-api jar in local maven repository");
        System.out.println("ERROR: To fix this, delete the javax/xml/ws/jaxws-api/2.1 directory");
        System.out.println("ERROR: and rerun the distribution build");
        System.out.println("===================================================================");
        System.exit(1);
    }

    private static void checkPomFile(String repo) {
        try {
            FileReader jaxwsPom = new FileReader(repo + "/javax/xml/ws/jaxws-api/2.1/jaxws-api-2.1.pom");
            BufferedReader reader = new BufferedReader(jaxwsPom);
            while (!reader.readLine().contains("saaj-api")) {
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("===================================================================");
            System.out.println("ERROR: Incorrect version of jaxws-api pom in local maven repository");
            System.out.println("ERROR: To fix this, delete the javax/xml/ws/jaxws-api/2.1 directory");
            System.out.println("ERROR: and rerun the distribution build");
            System.out.println("===================================================================");
            System.exit(1);
            return;
        }
    }
}

