/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerFactory;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.CompositeBuilderImpl;
import org.apache.tuscany.sca.assembly.builder.impl.CompositeIncludeBuilderImpl;
import org.apache.tuscany.sca.assembly.xml.CompositeDocumentProcessor;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ExtensibleURLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.resolver.DefaultModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.definitions.impl.SCADefinitionsImpl;
import org.apache.tuscany.sca.definitions.util.SCADefinitionsUtil;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerConfiguration;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerUtil;
import org.apache.tuscany.sca.implementation.node.NodeImplementation;
import org.apache.tuscany.sca.implementation.node.builder.impl.NodeCompositeBuilderImpl;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.MonitorRuntimeException;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.IntentAttachPointTypeFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.provider.SCADefinitionsProvider;
import org.apache.tuscany.sca.provider.SCADefinitionsProviderExtensionPoint;
import org.apache.tuscany.sca.workspace.Workspace;
import org.apache.tuscany.sca.workspace.WorkspaceFactory;
import org.apache.tuscany.sca.workspace.builder.ContributionDependencyBuilder;
import org.apache.tuscany.sca.workspace.builder.impl.ContributionDependencyBuilderImpl;
import org.apache.tuscany.sca.workspace.processor.impl.ContributionContentProcessor;
import org.osoa.sca.ServiceRuntimeException;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

@Scope(value="COMPOSITE")
@Service(value=Servlet.class)
public class CompositeConfigurationServiceImpl
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = -8809641932774129152L;
    private static final Logger logger = Logger.getLogger(CompositeConfigurationServiceImpl.class.getName());
    @Reference
    public LocalItemCollection contributionCollection;
    @Reference
    public LocalItemCollection domainCompositeCollection;
    @Reference
    public DomainManagerConfiguration domainManagerConfiguration;
    @Reference
    public LocalItemCollection cloudCollection;
    private ExtensionPointRegistry extensionPoints;
    private ModelFactoryExtensionPoint modelFactories;
    private ModelResolverExtensionPoint modelResolvers;
    private AssemblyFactory assemblyFactory;
    private WorkspaceFactory workspaceFactory;
    private URLArtifactProcessor<Contribution> contributionProcessor;
    private StAXArtifactProcessorExtensionPoint staxProcessors;
    private StAXArtifactProcessor<Composite> compositeProcessor;
    private XMLOutputFactory outputFactory;
    private ContributionDependencyBuilder contributionDependencyBuilder;
    private CompositeBuilder compositeIncludeBuilder;
    private CompositeBuilder nodeConfigurationBuilder;
    private Monitor monitor;
    private List<SCADefinitions> policyDefinitions;
    private ModelResolver policyDefinitionsResolver;
    private SCABindingFactory scaBindingFactory;
    private IntentAttachPointTypeFactory intentAttachPointTypeFactory;
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;
    private InterfaceContractMapper contractMapper;
    private Map<Binding, Binding> bindingMap;

    @Init
    public void initialize() throws ParserConfigurationException {
        this.extensionPoints = this.domainManagerConfiguration.getExtensionPoints();
        UtilityExtensionPoint utilities = this.extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = utilities.getUtility(MonitorFactory.class);
        this.monitor = monitorFactory.createMonitor();
        this.modelFactories = this.extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.assemblyFactory = this.modelFactories.getFactory(AssemblyFactory.class);
        XMLInputFactory inputFactory = this.modelFactories.getFactory(XMLInputFactory.class);
        this.outputFactory = this.modelFactories.getFactory(XMLOutputFactory.class);
        this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        this.workspaceFactory = this.modelFactories.getFactory(WorkspaceFactory.class);
        this.staxProcessors = this.extensionPoints.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.compositeProcessor = (StAXArtifactProcessor)this.staxProcessors.getProcessor(Composite.class);
        ExtensibleStAXArtifactProcessor staxProcessor = new ExtensibleStAXArtifactProcessor(this.staxProcessors, inputFactory, this.outputFactory, this.monitor);
        URLArtifactProcessorExtensionPoint urlProcessors = this.extensionPoints.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        ExtensibleURLArtifactProcessor urlProcessor = new ExtensibleURLArtifactProcessor(urlProcessors, this.monitor);
        this.policyDefinitionsResolver = new DefaultModelResolver();
        this.policyDefinitions = new ArrayList<SCADefinitions>();
        XMLInputFactory validatingInputFactory = this.modelFactories.getFactory(ValidatingXMLInputFactory.class);
        this.documentBuilderFactory = this.modelFactories.getFactory(DocumentBuilderFactory.class);
        urlProcessors.getProcessor(Composite.class);
        urlProcessors.addArtifactProcessor(new CompositeDocumentProcessor(staxProcessor, validatingInputFactory, this.documentBuilderFactory, this.policyDefinitions, this.monitor));
        this.modelResolvers = this.extensionPoints.getExtensionPoint(ModelResolverExtensionPoint.class);
        this.contributionProcessor = new ContributionContentProcessor(this.extensionPoints, this.monitor, this.policyDefinitionsResolver, this.policyDefinitions);
        this.transformerFactory = this.modelFactories.getFactory(TransformerFactory.class);
        this.contributionDependencyBuilder = new ContributionDependencyBuilderImpl(this.monitor);
        this.scaBindingFactory = this.modelFactories.getFactory(SCABindingFactory.class);
        this.intentAttachPointTypeFactory = this.modelFactories.getFactory(IntentAttachPointTypeFactory.class);
        this.contractMapper = utilities.getUtility(InterfaceContractMapper.class);
        this.compositeIncludeBuilder = new CompositeIncludeBuilderImpl(this.monitor);
        this.bindingMap = new HashMap<Binding, Binding>();
        this.nodeConfigurationBuilder = new NodeCompositeBuilderImpl(this.assemblyFactory, this.scaBindingFactory, this.documentBuilderFactory, this.transformerFactory, this.contractMapper, null, this.monitor, this.bindingMap);
        this.loadSCADefinitions(this.extensionPoints);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StAXArtifactProcessor processor;
        Composite cloudsComposite;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        String key = path.startsWith("/") ? (path.length() > 1 ? path.substring(1) : "") : path;
        logger.fine("get " + key);
        String requestedContributionURI = null;
        QName requestedCompositeName = null;
        String[] requestedComponentPath = null;
        if (key.startsWith("composite:")) {
            requestedContributionURI = DomainManagerUtil.contributionURI(key);
            requestedCompositeName = DomainManagerUtil.compositeQName(key);
        } else if (key.length() != 0) {
            requestedComponentPath = key.split("/");
        }
        Composite requestedComposite = null;
        Composite domainComposite = this.assemblyFactory.createComposite();
        domainComposite.setName(new QName("http://tuscany.apache.org/xmlns/sca/1.0", "domain"));
        Entry<K, D>[] domainEntries = this.domainCompositeCollection.getAll();
        Workspace workspace = this.workspaceFactory.createWorkspace();
        workspace.setModelResolver(new ExtensibleModelResolver(workspace, this.extensionPoints));
        HashMap<String, Contribution> contributionMap = new HashMap<String, Contribution>();
        for (Entry domainEntry : domainEntries) {
            String contributionURI = DomainManagerUtil.contributionURI((String)domainEntry.getKey());
            Contribution contribution = (Contribution)contributionMap.get(contributionURI);
            if (contribution == null) {
                Entry<K, D>[] entries;
                for (Entry entry : entries = this.contributionCollection.query("alldependencies=" + contributionURI)) {
                    Contribution dependency;
                    Item dependencyItem = (Item)entry.getData();
                    String dependencyURI = (String)entry.getKey();
                    if (contributionMap.containsKey(dependencyURI)) continue;
                    try {
                        String dependencyLocation = dependencyItem.getAlternate();
                        dependency = this.contribution(workspace, dependencyURI, dependencyLocation);
                    }
                    catch (Exception e) {
                        if (!contributionURI.equals(dependencyURI)) continue;
                        response.sendError(500, this.getDescription(e));
                        return;
                    }
                    workspace.getContributions().add(dependency);
                    contributionMap.put(dependencyURI, dependency);
                    if (!contributionURI.equals(entry.getKey())) continue;
                    contribution = dependency;
                }
            }
            if (contribution == null) {
                response.sendError(404, contributionURI);
                return;
            }
            Composite deployable = null;
            QName qn = DomainManagerUtil.compositeQName((String)domainEntry.getKey());
            for (Composite d : contribution.getDeployables()) {
                if (!qn.equals(d.getName())) continue;
                deployable = d;
                break;
            }
            if (deployable == null) {
                response.sendError(404, qn.toString());
                return;
            }
            domainComposite.getIncludes().add(deployable);
            try {
                this.compositeIncludeBuilder.build(deployable);
                this.analyzeProblems();
            }
            catch (Exception e) {
                response.sendError(500, this.getDescription(e));
                return;
            }
            if (requestedCompositeName == null || !requestedContributionURI.equals(contributionURI) || !requestedCompositeName.equals(deployable.getName())) continue;
            requestedComposite = deployable;
        }
        if (requestedCompositeName != null && requestedComposite == null) {
            response.sendError(404, key);
            return;
        }
        try {
            cloudsComposite = this.cloud();
        }
        catch (NotFoundException e) {
            response.sendError(404, e.getMessage());
            return;
        }
        List<Composite> domainIncludes = domainComposite.getIncludes();
        int n = domainIncludes.size();
        for (int i = 0; i < n; ++i) {
            Composite composite = domainIncludes.get(i);
            QName compositeName = composite.getName();
            String contributionURI = DomainManagerUtil.contributionURI((String)domainEntries[i].getKey());
            Component nodeComponent = null;
            QName nodeCompositeName = null;
            block16: for (Composite cloudComposite : cloudsComposite.getIncludes()) {
                for (Component nc : cloudComposite.getComponents()) {
                    NodeImplementation nodeImplementation = (NodeImplementation)nc.getImplementation();
                    if (!nodeImplementation.getComposite().getName().equals(compositeName) || !nodeImplementation.getComposite().getURI().equals(contributionURI)) continue;
                    nodeImplementation.setComposite(composite);
                    nodeComponent = nc;
                    nodeCompositeName = cloudComposite.getName();
                    continue block16;
                }
            }
            if (nodeComponent == null) continue;
            try {
                Composite nodeComposite = this.assemblyFactory.createComposite();
                nodeComposite.setName(nodeCompositeName);
                nodeComposite.getComponents().add(nodeComponent);
                this.nodeConfigurationBuilder.build(nodeComposite);
                continue;
            }
            catch (CompositeBuilderException e) {
                throw new ServletException((Throwable)e);
            }
        }
        SCADefinitionsImpl aggregatedDefinitions = new SCADefinitionsImpl();
        for (SCADefinitions definition : this.policyDefinitions) {
            SCADefinitionsUtil.aggregateSCADefinitions(definition, aggregatedDefinitions);
        }
        CompositeBuilderImpl compositeBuilder = new CompositeBuilderImpl(this.assemblyFactory, null, this.scaBindingFactory, this.intentAttachPointTypeFactory, this.documentBuilderFactory, this.transformerFactory, this.contractMapper, aggregatedDefinitions, this.monitor, this.bindingMap);
        try {
            compositeBuilder.build(domainComposite);
            this.analyzeProblems();
        }
        catch (Exception e) {
            response.sendError(500, this.getDescription(e));
            return;
        }
        if (requestedComposite != null) {
            ArrayList<Component> tempComponentList = new ArrayList<Component>();
            tempComponentList.addAll(requestedComposite.getComponents());
            requestedComposite.getComponents().clear();
            for (Component inputComponent : tempComponentList) {
                for (Component deployComponent : domainComposite.getComponents()) {
                    if (!deployComponent.getName().equals(inputComponent.getName())) continue;
                    requestedComposite.getComponents().add(deployComponent);
                }
            }
        } else if (requestedComponentPath != null) {
            Composite nestedComposite = domainComposite;
            for (String componentName : requestedComponentPath) {
                Component component = null;
                for (Component c : nestedComposite.getComponents()) {
                    if (!componentName.equals(c.getName())) continue;
                    component = c;
                    break;
                }
                if (component == null) {
                    response.sendError(404, key);
                    return;
                }
                if (!(component.getImplementation() instanceof Composite)) {
                    response.sendError(404, key);
                    return;
                }
                nestedComposite = (Composite)component.getImplementation();
            }
            requestedComposite = nestedComposite;
        } else {
            requestedComposite = domainComposite;
        }
        String queryString = request.getQueryString();
        if (queryString != null && queryString.startsWith("format=")) {
            int s;
            String format = queryString.substring(7);
            QName formatName = new QName(format.substring(0, s = format.indexOf(59)), format.substring(s + 1));
            processor = (StAXArtifactProcessor)this.staxProcessors.getProcessor(formatName);
            if (processor == null) {
                response.sendError(500, new IllegalArgumentException(queryString).toString());
                return;
            }
        } else {
            processor = this.compositeProcessor;
        }
        try {
            response.setContentType("text/xml");
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter((OutputStream)response.getOutputStream());
            processor.write((Composite)requestedComposite, writer);
        }
        catch (Exception e) {
            response.sendError(500, e.toString());
            return;
        }
    }

    private Composite cloud() throws NotFoundException {
        Composite cloudComposite = this.assemblyFactory.createComposite();
        cloudComposite.setName(new QName("http://tuscany.apache.org/xmlns/sca/1.0", "cloud"));
        Entry<K, D>[] cloudEntries = this.cloudCollection.getAll();
        Workspace workspace = this.workspaceFactory.createWorkspace();
        HashMap<String, Contribution> contributionMap = new HashMap<String, Contribution>();
        for (Entry cloudEntry : cloudEntries) {
            String key = (String)cloudEntry.getKey();
            String contributionURI = DomainManagerUtil.contributionURI(key);
            Contribution contribution = (Contribution)contributionMap.get(contributionURI);
            if (contribution == null) {
                Item contributionItem = (Item)this.contributionCollection.get(contributionURI);
                try {
                    contribution = this.contribution(workspace, contributionURI, contributionItem.getAlternate());
                }
                catch (ContributionReadException e) {
                    continue;
                }
                workspace.getContributions().add(contribution);
                contributionMap.put(contributionURI, contribution);
            }
            QName qname = DomainManagerUtil.compositeQName(key);
            for (Artifact artifact : contribution.getArtifacts()) {
                Composite composite;
                if (!(artifact.getModel() instanceof Composite) || !(composite = (Composite)artifact.getModel()).getName().equals(qname)) continue;
                cloudComposite.getIncludes().add(composite);
            }
        }
        return cloudComposite;
    }

    private Contribution contribution(Workspace workspace, String contributionURI, String contributionLocation) throws ContributionReadException {
        try {
            URI uri = URI.create(contributionURI);
            URL location = DomainManagerUtil.locationURL(contributionLocation);
            Contribution contribution = this.contributionProcessor.read(null, uri, location);
            try {
                this.analyzeProblems();
            }
            catch (ServiceRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ContributionReadException(e);
            }
            this.contributionDependencyBuilder.buildContributionDependencies(contribution, workspace);
            this.contributionProcessor.resolve(contribution, workspace.getModelResolver());
            try {
                this.analyzeProblems();
            }
            catch (ServiceRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ContributionReadException(e);
            }
            return contribution;
        }
        catch (ContributionReadException e) {
            throw e;
        }
        catch (ContributionResolveException e) {
            throw new ContributionReadException(e);
        }
        catch (MalformedURLException e) {
            throw new ContributionReadException(e);
        }
    }

    private void analyzeProblems() throws Exception {
        for (Problem problem : this.monitor.getProblems()) {
            if (problem.getSeverity() != Problem.Severity.ERROR || problem.getMessageId().equals("SchemaError")) continue;
            if (problem.getCause() != null) {
                throw new ServiceRuntimeException(new MonitorRuntimeException(problem.getCause()));
            }
            throw new ServiceRuntimeException(new MonitorRuntimeException(problem.toString()));
        }
    }

    private String getDescription(Exception e) {
        if (e instanceof ServiceRuntimeException && e.getCause() instanceof MonitorRuntimeException) {
            Throwable ce = e.getCause();
            return ce.getCause() != null ? ce.getCause().toString() : ce.getMessage();
        }
        return e.toString();
    }

    private void loadSCADefinitions(ExtensionPointRegistry registry) throws ParserConfigurationException {
        try {
            URLArtifactProcessorExtensionPoint documentProcessors = registry.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
            URLArtifactProcessor definitionsProcessor = (URLArtifactProcessor)documentProcessors.getProcessor(SCADefinitions.class);
            SCADefinitionsProviderExtensionPoint scaDefnProviders = registry.getExtensionPoint(SCADefinitionsProviderExtensionPoint.class);
            SCADefinitionsImpl systemSCADefinitions = new SCADefinitionsImpl();
            SCADefinitions aSCADefn = null;
            for (SCADefinitionsProvider aProvider : scaDefnProviders.getSCADefinitionsProviders()) {
                aSCADefn = aProvider.getSCADefinition();
                SCADefinitionsUtil.aggregateSCADefinitions(aSCADefn, systemSCADefinitions);
            }
            this.policyDefinitions.add(systemSCADefinitions);
            for (Intent intent : systemSCADefinitions.getPolicyIntents()) {
                this.policyDefinitionsResolver.addModel(intent);
            }
            for (PolicySet policySet : systemSCADefinitions.getPolicySets()) {
                this.policyDefinitionsResolver.addModel(policySet);
            }
            for (IntentAttachPointType attachPoinType : systemSCADefinitions.getBindingTypes()) {
                this.policyDefinitionsResolver.addModel(attachPoinType);
            }
            for (IntentAttachPointType attachPoinType : systemSCADefinitions.getImplementationTypes()) {
                this.policyDefinitionsResolver.addModel(attachPoinType);
            }
            definitionsProcessor.resolve(systemSCADefinitions, this.policyDefinitionsResolver);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }
}

