/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.DefaultExport;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.ItemCollection;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerConfiguration;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerUtil;
import org.apache.tuscany.sca.domain.search.DomainSearch;
import org.apache.tuscany.sca.domain.search.IndexException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.workspace.Workspace;
import org.apache.tuscany.sca.workspace.WorkspaceFactory;
import org.apache.tuscany.sca.workspace.builder.impl.ContributionDependencyBuilderImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.osoa.sca.ServiceRuntimeException;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value="COMPOSITE")
@Service(interfaces={ItemCollection.class, LocalItemCollection.class})
public class ContributionCollectionImpl
implements ItemCollection,
LocalItemCollection {
    private static final Logger logger = Logger.getLogger(ContributionCollectionImpl.class.getName());
    @Property
    public String workspaceFile;
    @Property
    public String deploymentContributionDirectory;
    @Reference
    public DomainManagerConfiguration domainManagerConfiguration;
    @Reference
    public DomainSearch domainSearch;
    private Monitor monitor;
    private ContributionFactory contributionFactory;
    private WorkspaceFactory workspaceFactory;
    private StAXArtifactProcessor<Object> staxProcessor;
    private URLArtifactProcessor<Contribution> contributionProcessor;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private DocumentBuilder documentBuilder;
    private Cache cache = new Cache();

    @Init
    public void initialize() throws ParserConfigurationException {
        ExtensionPointRegistry extensionPoints = this.domainManagerConfiguration.getExtensionPoints();
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = utilities.getUtility(MonitorFactory.class);
        this.monitor = monitorFactory.createMonitor();
        ModelFactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.outputFactory = modelFactories.getFactory(XMLOutputFactory.class);
        this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.workspaceFactory = modelFactories.getFactory(WorkspaceFactory.class);
        this.inputFactory = modelFactories.getFactory(XMLInputFactory.class);
        StAXArtifactProcessorExtensionPoint staxProcessors = extensionPoints.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.staxProcessor = new ExtensibleStAXArtifactProcessor(staxProcessors, this.inputFactory, this.outputFactory, this.monitor);
        URLArtifactProcessorExtensionPoint urlProcessors = extensionPoints.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        this.contributionProcessor = (URLArtifactProcessor)urlProcessors.getProcessor(".contribution/info");
        this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    @Override
    public Entry<String, Item>[] getAll() {
        logger.fine("getAll");
        ArrayList<Entry<String, Item>> entries = new ArrayList<Entry<String, Item>>();
        Workspace workspace = this.readContributions(this.readWorkspace());
        for (Contribution contribution : workspace.getContributions()) {
            if (contribution.getURI().equals("http://tuscany.apache.org/cloud")) continue;
            entries.add(ContributionCollectionImpl.entry(workspace, contribution));
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    @Override
    public Item get(String key) throws NotFoundException {
        logger.fine("get " + key);
        Workspace workspace = this.readContributions(this.readWorkspace());
        for (Contribution contribution : workspace.getContributions()) {
            if (!key.equals(contribution.getURI())) continue;
            return ContributionCollectionImpl.item(workspace, contribution);
        }
        throw new NotFoundException(key);
    }

    @Override
    public String post(String key, Item item) {
        logger.fine("post " + key);
        Workspace workspace = this.readWorkspace();
        Contribution contribution = this.contributionFactory.createContribution();
        contribution.setURI(key);
        try {
            contribution.setLocation(DomainManagerUtil.locationURL(item.getLink()).toString());
        }
        catch (MalformedURLException e) {
            throw new ServiceRuntimeException(e);
        }
        workspace.getContributions().add(contribution);
        this.writeWorkspace(workspace);
        if (this.domainSearch != null) {
            try {
                this.domainSearch.updateContribution(contribution, contribution);
            }
            catch (IndexException e) {
                logger.warning("Could not update contribution on index: " + contribution.getURI());
            }
        }
        return key;
    }

    @Override
    public void put(String key, Item item) throws NotFoundException {
        Workspace workspace = this.readWorkspace();
        Contribution newContribution = this.contributionFactory.createContribution();
        newContribution.setURI(key);
        try {
            newContribution.setLocation(DomainManagerUtil.locationURL(item.getLink()).toString());
        }
        catch (MalformedURLException e) {
            throw new ServiceRuntimeException(e);
        }
        List<Contribution> contributions = workspace.getContributions();
        int n = contributions.size();
        for (int i = 0; i < n; ++i) {
            if (!contributions.get(i).getURI().equals(key)) continue;
            contributions.set(i, newContribution);
            this.writeWorkspace(workspace);
            return;
        }
        throw new NotFoundException(key);
    }

    @Override
    public void delete(String key) throws NotFoundException {
        logger.fine("delete " + key);
        Workspace workspace = this.readWorkspace();
        List<Contribution> contributions = workspace.getContributions();
        int n = contributions.size();
        for (int i = 0; i < n; ++i) {
            Contribution contribution = contributions.get(i);
            if (!contribution.getURI().equals(key)) continue;
            contributions.remove(i);
            this.writeWorkspace(workspace);
            if (this.domainSearch != null) {
                try {
                    this.domainSearch.removeContribution(contribution);
                }
                catch (IndexException e) {
                    logger.warning("Could not remove contribution from index: " + contribution.getURI());
                }
            }
            return;
        }
        throw new NotFoundException(key);
    }

    @Override
    public Entry<String, Item>[] query(String queryString) {
        logger.fine("query " + queryString);
        if (queryString.startsWith("dependencies=") || queryString.startsWith("alldependencies=")) {
            ArrayList<Entry<String, Item>> entries = new ArrayList<Entry<String, Item>>();
            int eq = queryString.indexOf(61);
            String key = queryString.substring(eq + 1);
            Workspace workspace = this.readContributions(this.readWorkspace());
            for (Contribution contribution : workspace.getContributions()) {
                if (!key.equals(contribution.getURI())) continue;
                ContributionDependencyBuilderImpl analyzer = new ContributionDependencyBuilderImpl(this.monitor);
                List<Contribution> dependencies = analyzer.buildContributionDependencies(contribution, workspace);
                boolean allDependencies = queryString.startsWith("alldependencies=");
                for (Contribution dependency : dependencies) {
                    if (!allDependencies && dependency == contribution) continue;
                    entries.add(ContributionCollectionImpl.entry(workspace, dependency));
                }
            }
            return entries.toArray(new Entry[entries.size()]);
        }
        if (queryString.startsWith("suggestions=true")) {
            Workspace suggestionWorkspace = this.workspaceFactory.createWorkspace();
            ArrayList<Entry<String, Item>> entries = new ArrayList<Entry<String, Item>>();
            String rootDirectory = this.domainManagerConfiguration.getRootDirectory();
            File rootLocation = new File(new File(rootDirectory).toURI().normalize());
            for (File project : rootLocation.getParentFile().listFiles()) {
                String locationPath;
                String rootLocationPath;
                File dotProject = new File(project, ".project");
                if (!dotProject.exists()) continue;
                String uri = project.getName();
                File location = project;
                File dotClasspath = new File(project, ".classpath");
                if (dotClasspath.exists()) {
                    try {
                        XMLStreamReader reader = this.inputFactory.createXMLStreamReader(new FileInputStream(dotClasspath));
                        reader.nextTag();
                        while (reader.hasNext()) {
                            int event = reader.getEventType();
                            if (event == 1 && "classpathentry".equals(reader.getName().getLocalPart()) && "output".equals(reader.getAttributeValue("", "kind"))) {
                                location = new File(project, reader.getAttributeValue("", "path"));
                                break;
                            }
                            if (!reader.hasNext()) continue;
                            reader.next();
                        }
                    }
                    catch (FileNotFoundException e) {
                    }
                    catch (XMLStreamException e) {
                        // empty catch block
                    }
                }
                if ((rootLocationPath = rootLocation.getPath()).indexOf(92) != -1 || rootLocationPath.indexOf(32) != -1) {
                    rootLocationPath = new File(rootLocationPath.replace('\\', '/')).toURI().toString();
                }
                if ((locationPath = location.getPath()).indexOf(92) != -1 || locationPath.indexOf(32) != -1) {
                    locationPath = new File(locationPath.replace('\\', '/')).toURI().toString();
                }
                if (locationPath.startsWith(rootLocationPath + "/") || locationPath.equals(rootLocationPath)) continue;
                Contribution contribution = this.contributionFactory.createContribution();
                contribution.setURI(uri);
                contribution.setLocation(locationPath);
                entries.add(ContributionCollectionImpl.entry(suggestionWorkspace, contribution));
            }
            return entries.toArray(new Entry[entries.size()]);
        }
        throw new UnsupportedOperationException();
    }

    private static Entry<String, Item> entry(Workspace workspace, Contribution contribution) {
        Entry<String, Item> entry = new Entry<String, Item>();
        entry.setKey(contribution.getURI());
        entry.setData(ContributionCollectionImpl.item(workspace, contribution));
        return entry;
    }

    private static Item item(Workspace workspace, Contribution contribution) {
        int i;
        List<Composite> deployables;
        String contributionURI = contribution.getURI();
        Item item = new Item();
        item.setTitle(ContributionCollectionImpl.title(contributionURI));
        item.setLink(ContributionCollectionImpl.link(contributionURI));
        item.setAlternate(contribution.getLocation());
        final ArrayList<String> problems = new ArrayList<String>();
        Monitor monitor = new Monitor(){

            @Override
            public void problem(Problem problem) {
                problems.add(problem.getMessageId() + " " + problem.getProblemObject().toString());
            }

            @Override
            public List<Problem> getProblems() {
                return null;
            }

            @Override
            public Problem createProblem(String sourceClassName, String bundleName, Problem.Severity severity, Object problemObject, String messageId, Exception cause) {
                return new ProblemImpl(sourceClassName, bundleName, severity, problemObject, messageId, cause);
            }

            @Override
            public Problem createProblem(String sourceClassName, String bundleName, Problem.Severity severity, Object problemObject, String messageId, Object ... messageParams) {
                return new ProblemImpl(sourceClassName, bundleName, severity, problemObject, messageId, messageParams);
            }
        };
        StringBuffer sb = new StringBuffer();
        ContributionDependencyBuilderImpl analyzer = new ContributionDependencyBuilderImpl(monitor);
        List<Contribution> dependencies = analyzer.buildContributionDependencies(contribution, workspace);
        if (dependencies.size() > 1) {
            sb.append("Dependencies: <span id=\"dependencies\">");
            int n = dependencies.size();
            for (int i2 = 0; i2 < n; ++i2) {
                Contribution dependency;
                if (i2 > 0) {
                    sb.append("  ");
                }
                if ((dependency = dependencies.get(i2)) == contribution) continue;
                String dependencyURI = dependency.getURI();
                sb.append("<a href=\"" + ContributionCollectionImpl.link(dependencyURI) + "\">" + ContributionCollectionImpl.title(dependencyURI) + "</a>");
            }
            sb.append("</span><br>");
        }
        if (!(deployables = contribution.getDeployables()).isEmpty()) {
            sb.append("Deployables: <span id=\"deployables\">");
            int n = deployables.size();
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append("  ");
                }
                Composite deployable = deployables.get(i);
                QName qname = deployable.getName();
                sb.append("<a href=\"" + DomainManagerUtil.compositeSourceLink(contributionURI, qname) + "\">" + DomainManagerUtil.compositeSimpleTitle(contributionURI, qname) + "</a>");
            }
            sb.append("</span><br>");
        }
        if (contribution.isUnresolved()) {
            problems.add("Contribution not found");
        }
        if (problems.size() > 0) {
            sb.append("<span id=\"problems\" style=\"color: red\">");
            int n = problems.size();
            for (i = 0; i < n; ++i) {
                sb.append("Problem: " + (String)problems.get(i) + "<br>");
            }
            sb.append("</span>");
        }
        item.setContents(sb.toString());
        return item;
    }

    private static String link(String contributionURI) {
        return "/contribution/" + contributionURI;
    }

    private static String title(String contributionURI) {
        return contributionURI;
    }

    Workspace readWorkspace() {
        Workspace workspace;
        String rootDirectory = this.domainManagerConfiguration.getRootDirectory();
        File file = new File(rootDirectory + "/" + this.workspaceFile);
        if (file.exists()) {
            if (this.cache.workspace != null && file.lastModified() == this.cache.workspaceLastModified) {
                workspace = this.cache.workspace;
            } else {
                try {
                    FileInputStream is = new FileInputStream(file);
                    XMLStreamReader reader = this.inputFactory.createXMLStreamReader(is);
                    reader.nextTag();
                    workspace = (Workspace)this.staxProcessor.read(reader);
                }
                catch (Exception e) {
                    throw new ServiceRuntimeException(e);
                }
                this.cache.workspaceLastModified = file.lastModified();
                this.cache.workspace = workspace;
            }
        } else {
            workspace = this.workspaceFactory.createWorkspace();
            this.cache.workspaceLastModified = 0L;
            this.cache.workspace = workspace;
        }
        Contribution cloudContribution = null;
        for (Contribution contribution : workspace.getContributions()) {
            if (!contribution.getURI().equals("http://tuscany.apache.org/cloud")) continue;
            cloudContribution = contribution;
        }
        if (cloudContribution == null) {
            Contribution contribution = this.contributionFactory.createContribution();
            contribution.setURI("http://tuscany.apache.org/cloud");
            File cloudDirectory = new File(rootDirectory + "/" + this.deploymentContributionDirectory);
            contribution.setLocation(cloudDirectory.toURI().toString());
            workspace.getContributions().add(contribution);
        }
        return workspace;
    }

    private void writeWorkspace(Workspace workspace) {
        try {
            String rootDirectory = this.domainManagerConfiguration.getRootDirectory();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(bos);
            this.staxProcessor.write(workspace, writer);
            Document document = this.documentBuilder.parse(new ByteArrayInputStream(bos.toByteArray()));
            OutputFormat format = new OutputFormat();
            format.setIndenting(true);
            format.setIndent(2);
            File file = new File(rootDirectory + "/" + this.workspaceFile);
            FileOutputStream os = new FileOutputStream(file);
            XMLSerializer serializer = new XMLSerializer((OutputStream)os, format);
            serializer.serialize(document);
            os.close();
            this.cache.workspace = workspace;
            this.cache.workspaceLastModified = file.lastModified();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    private Workspace readContributions(Workspace workspace) {
        Workspace contributions = this.workspaceFactory.createWorkspace();
        try {
            for (Contribution c : workspace.getContributions()) {
                Contribution contribution;
                URI uri = URI.create(c.getURI());
                URL location = DomainManagerUtil.locationURL(c.getLocation());
                Cache.ContributionCache contributionCache = (Cache.ContributionCache)this.cache.contributions.get(location);
                long lastModified = DomainManagerUtil.lastModified(location);
                if (contributionCache != null) {
                    if (contributionCache.contributionLastModified == lastModified) {
                        contribution = contributionCache.contribution;
                        contribution.setUnresolved(false);
                        contributions.getContributions().add(contribution);
                        continue;
                    }
                    this.cache.contributions.remove(location);
                }
                try {
                    contribution = this.contributionProcessor.read(null, uri, location);
                    contribution.setUnresolved(false);
                    contributions.getContributions().add(contribution);
                    contributionCache = new Cache.ContributionCache();
                    contributionCache.contribution = contribution;
                    contributionCache.contributionLastModified = lastModified;
                    this.cache.contributions.put(location, contributionCache);
                    if (!contribution.getURI().equals("http://tuscany.apache.org/cloud")) continue;
                    Iterator<Extensible> i = contribution.getImports().iterator();
                    while (i.hasNext()) {
                        Import import_ = i.next();
                        if (!(import_ instanceof DefaultImport)) continue;
                        i.remove();
                    }
                    i = contribution.getExports().iterator();
                    while (i.hasNext()) {
                        Export export = (Export)i.next();
                        if (!(export instanceof DefaultExport)) continue;
                        i.remove();
                    }
                }
                catch (ContributionReadException e) {
                    Contribution contribution2 = this.contributionFactory.createContribution();
                    contribution2.setURI(c.getURI());
                    contribution2.setLocation(c.getLocation());
                    contribution2.setUnresolved(true);
                    contributions.getContributions().add(contribution2);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        return contributions;
    }

    static class Cache {
        private Workspace workspace;
        private long workspaceLastModified;
        private Map<URL, ContributionCache> contributions = new HashMap<URL, ContributionCache>();

        Cache() {
        }

        static class ContributionCache {
            private Contribution contribution;
            private long contributionLastModified;

            ContributionCache() {
            }
        }
    }
}

