/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerConfiguration;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

@Scope(value="COMPOSITE")
@Service(value=Servlet.class)
public class FileServiceImpl
extends HttpServlet {
    private static final long serialVersionUID = -4560385595481971616L;
    private static final Logger logger = Logger.getLogger(FileServiceImpl.class.getName());
    @Property
    public String directoryName;
    @Reference
    public DomainManagerConfiguration domainManagerConfiguration;
    @Reference
    public LocalItemCollection contributionCollection;
    private ServletFileUpload upload;

    @Init
    public void initialize() throws IOException {
        this.upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String rootDirectory = this.domainManagerConfiguration.getRootDirectory();
        try {
            for (FileItem item : this.upload.parseRequest(request)) {
                if (item.isFormField()) continue;
                File directory = new File(rootDirectory + "/" + this.directoryName);
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                logger.fine("post " + item.getName());
                item.write(new File(directory, item.getName()));
            }
            response.sendRedirect("/ui/files");
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestURI = URLDecoder.decode(request.getRequestURI(), "UTF-8");
        String path = requestURI.substring(request.getServletPath().length());
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        logger.fine("get " + path);
        try {
            int n;
            String artifactURI;
            if (path.startsWith("contribution=")) {
                int semicolonIndex = path.indexOf(59);
                String contributionName = path.substring("contribution=".length(), semicolonIndex);
                artifactURI = path.substring(semicolonIndex + 1);
                try {
                    Item item = (Item)this.contributionCollection.get(contributionName);
                    if (item == null) {
                        response.sendError(404);
                        return;
                    }
                    path = item.getAlternate();
                }
                catch (NotFoundException e) {
                    response.sendError(404);
                    return;
                }
                path = path.endsWith(".jar") || path.endsWith(".zip") ? "jar:" + (path.startsWith("file:") ? "" : "file:") + path + '!' + (artifactURI.startsWith("/") ? "" : "/") + artifactURI : path + (path.endsWith("/") ? "" : "/") + artifactURI;
            } else {
                artifactURI = null;
            }
            URI uri = URI.create(path);
            String scheme = uri.getScheme();
            if (scheme == null) {
                if (artifactURI != null) {
                    uri = URI.create("file:" + uri.toString());
                } else {
                    String rootDirectory = this.domainManagerConfiguration.getRootDirectory();
                    uri = new File(rootDirectory + "/" + this.directoryName, path).toURI();
                }
            } else if (!scheme.equals("file") && !scheme.equals("jar")) {
                response.sendRedirect(path);
            }
            URLConnection connection = uri.toURL().openConnection();
            connection.setUseCaches(false);
            connection.connect();
            InputStream is = connection.getInputStream();
            ServletOutputStream os = response.getOutputStream();
            byte[] buffer = new byte[4096];
            while ((n = is.read(buffer)) >= 0) {
                os.write(buffer, 0, n);
            }
            is.close();
            os.flush();
        }
        catch (FileNotFoundException e) {
            response.sendError(404);
        }
    }
}

