/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.ItemCollection;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.domain.manager.impl.ContributionsReader;
import org.apache.tuscany.sca.domain.search.DomainSearch;
import org.apache.tuscany.sca.domain.search.IndexException;
import org.apache.tuscany.sca.domain.search.Result;
import org.apache.tuscany.sca.domain.search.impl.DomainSearchFormatter;
import org.apache.tuscany.sca.domain.search.impl.HighlightingUtil;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value="COMPOSITE")
@Service(interfaces={ItemCollection.class, LocalItemCollection.class})
public class Searcher
implements ItemCollection,
LocalItemCollection {
    static char[] characters = new char[]{'\u0001', '\u0003', '\u0004'};
    private static final String HTML_NEW_LINE = "<BR/>";
    private static final String PATH_SEPARATOR = "/";
    private static final int MAX_CONTENT_LINE_WIDTH = 300;
    private static final String HIGHLIGHT_START = "<font color='#FF0000'>";
    private static final String HIGHLIGHT_END = "</font>";
    @Reference
    public ContributionsReader contributionReader;
    @Reference
    public LocalItemCollection contributionCollection;
    @Reference
    public DomainSearch domainSearch;
    private int elementCounter;

    @Override
    public void delete(String key) throws NotFoundException {
    }

    private static void startIndentation(int size, StringWriter writer) {
        writer.write("<p style='margin-top:0em;margin-bottom:0em;padding:0em;margin-left:");
        writer.write(Integer.toString(size));
        writer.write("em'>");
    }

    private static void endIndentation(StringWriter writer) {
        writer.write("</p>");
    }

    @Override
    public Item get(String key) throws NotFoundException {
        try {
            if (key.startsWith("highlight")) {
                int lastSemicolonIndex = key.lastIndexOf(";");
                String artifact = key.substring(lastSemicolonIndex + 1);
                int secondLastSemicolonIndex = key.lastIndexOf(";", lastSemicolonIndex - 1);
                String contribution = key.substring(secondLastSemicolonIndex + 1, lastSemicolonIndex);
                String query = key.substring("highlight".length(), secondLastSemicolonIndex);
                return this.highlightArtifact(contribution, artifact, query);
            }
            if (key.startsWith("query")) {
                return this.executeQuery(key.substring("query".length()));
            }
            throw new NotFoundException("Invalid operation!");
        }
        catch (Exception t) {
            if (t instanceof NotFoundException) {
                throw (NotFoundException)t;
            }
            throw new NotFoundException("Internal error!");
        }
    }

    private Item highlightArtifact(String contribution, String artifact, String query) throws NotFoundException {
        Item item = (Item)this.contributionCollection.get(contribution);
        if (item == null) {
            throw new NotFoundException("contribution not found: " + contribution);
        }
        String location = item.getAlternate();
        location = location.endsWith(".jar") || location.endsWith(".zip") ? "jar:" + (location.startsWith("file:") ? "" : "file:") + location + '!' + (artifact.startsWith(PATH_SEPARATOR) ? "" : PATH_SEPARATOR) + artifact : location + (location.endsWith(PATH_SEPARATOR) ? "" : PATH_SEPARATOR) + artifact;
        try {
            int c;
            InputStreamReader reader = new InputStreamReader(new URL(location).openStream());
            StringBuilder sb = new StringBuilder();
            while ((c = ((Reader)reader).read()) != -1) {
                char character = (char)c;
                if (Character.isIdentifierIgnorable(character)) continue;
                sb.append(character);
            }
            String highlightedText = this.domainSearch.highlight("filecontent", sb.toString(), query);
            highlightedText = highlightedText.replaceAll("\n", "<br/>");
            highlightedText = highlightedText.replaceAll(" ", "&nbsp;");
            highlightedText = HighlightingUtil.replaceHighlightMarkupBy(highlightedText, HIGHLIGHT_START, HIGHLIGHT_END);
            item = new Item();
            item.setTitle(contribution + ";" + artifact);
            item.setContents(highlightedText);
            return item;
        }
        catch (Exception e) {
            throw new NotFoundException("Could not highlight artifact: " + e.getMessage(), e);
        }
    }

    private Item executeQuery(String query) throws NotFoundException {
        Result[] results;
        if (!this.domainSearch.indexExists()) {
            Contribution[] contributions;
            for (Contribution contribution : contributions = this.contributionReader.readContributions()) {
                if (contribution.getURI().equals("http://tuscany.apache.org/cloud")) continue;
                try {
                    this.domainSearch.updateContribution(contribution, contribution);
                }
                catch (IndexException e) {
                    // empty catch block
                }
            }
        }
        try {
            results = this.domainSearch.parseAndSearch(query, true);
        }
        catch (Exception e1) {
            throw new NotFoundException("Exception while searching: " + e1.getMessage(), e1);
        }
        Item item = new Item();
        item.setTitle("Results");
        StringWriter sw = new StringWriter();
        this.elementCounter = 0;
        if (results.length > 0) {
            for (Result result : results) {
                try {
                    this.writeToHTML(0, result, sw);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            String contents = HighlightingUtil.replaceHighlightMarkupBy(sw.getBuffer(), HIGHLIGHT_START, HIGHLIGHT_END);
            item.setContents(Searcher.replaceAll(contents, 40));
        } else {
            item.setContents("No results match: <u>" + query + "</u>");
        }
        return item;
    }

    private static String replaceAll(CharSequence c, int less) {
        StringBuilder sb = new StringBuilder();
        Arrays.sort(characters);
        for (int i = 0; i < c.length(); ++i) {
            char actual = c.charAt(i);
            if (actual <= less && actual != '&' && actual != '#' && actual != '\'' && actual != ' ' && actual != '%' && actual != ':' && actual != '(' && actual != ')' && actual != '\"') continue;
            sb.append(actual);
        }
        return sb.toString();
    }

    private static String getIconLocationForResult(Result result) {
        if ("component".equals(result.getField())) {
            return "icons/component.png' title='Component";
        }
        if ("composite".equals(result.getField())) {
            return "icons/composite.png' title='Composite";
        }
        if ("artifact".equals(result.getField())) {
            return "icons/artifact.png' title='Artifact";
        }
        return "icons/feed-icon.png";
    }

    private static void writeResultIcon(Writer writer, Result result) throws IOException {
        writer.write("<img src='");
        writer.write(Searcher.getIconLocationForResult(result));
        writer.write("'/> ");
    }

    private static Result writeFileContentResultToHTML(int indentation, Result result, StringWriter writer) throws IOException {
        Map<String, Result> contents = result.getContents();
        Searcher.writeResultIcon(writer, result);
        if (contents.size() == 1 && "artifact".equals(contents.values().iterator().next().getField())) {
            writer.write(result.getValue());
            contents = result.getContents();
            while (contents.size() == 1 && "artifact".equals(contents.values().iterator().next().getField())) {
                result = contents.values().iterator().next();
                writer.write(PATH_SEPARATOR);
                StringEscapeUtils.escapeHtml((Writer)writer, (String)result.getValue());
                contents = result.getContents();
            }
        } else {
            StringEscapeUtils.escapeHtml((Writer)writer, (String)result.getValue());
        }
        return result;
    }

    private static String removeHighlighting(String text) {
        return HighlightingUtil.replaceHighlightMarkupBy(text, "", "");
    }

    private static void writeResultName(Result result, StringWriter writer) throws IOException {
        if ("contribution".equals(result.getField())) {
            writer.write("<a href='/contribution/");
            writer.write(Searcher.removeHighlighting(result.getValue()));
            writer.write("'>");
            writer.write(StringEscapeUtils.escapeHtml((String)result.getValue()));
            writer.write("</a>");
        } else if ("composite".equals(result.getField())) {
            writer.write("<a href='/composite-source/composite:");
            writer.write(Searcher.getContributionURI(result));
            writer.write(59);
            writer.write(Searcher.removeHighlighting(result.getValue()));
            writer.write("'>");
            writer.write(StringEscapeUtils.escapeHtml((String)result.getValue()));
            writer.write("</a>");
        } else {
            StringEscapeUtils.escapeHtml((Writer)writer, (String)result.getValue());
        }
    }

    private static String getContributionURI(Result result) {
        if (result == null) {
            return "";
        }
        if ("contribution".equals(result.getField())) {
            return Searcher.removeHighlighting(result.getValue());
        }
        return Searcher.getContributionURI(result.getContainer());
    }

    private void writeToHTML(int indentation, Result result, StringWriter writer) throws IOException {
        Searcher.startIndentation(indentation++, writer);
        String field = result.getField();
        if ("filecontent".equals(field)) {
            String content = result.getValue();
            if (content != null && content.length() > 0 && DomainSearchFormatter.isHighlighted(content)) {
                String contributionPlusArtifact = Searcher.getContributionURI(result) + ";" + Searcher.removeHighlighting(result.getContainer().getValue());
                writer.write(HTML_NEW_LINE);
                ++this.elementCounter;
                writer.write("<div style='margin-top:0em;margin-left:");
                writer.write(Integer.toString(indentation));
                writer.write("em;background-color:#FFE175;max-width:100%;border-style:dashed;border-width:1px;padding:5px' id='");
                writer.write(contributionPlusArtifact);
                writer.write("'>");
                writer.write("<p style='margin:0px;padding:0px;font-size:70%'>");
                writer.write("<a style='margin:0px;padding:0px' href='javascript:getHighlighted(\"");
                writer.write(contributionPlusArtifact);
                writer.write("\");'>view all</a>&nbsp;&nbsp;");
                writer.write("<a href='/files/contribution=");
                writer.write(contributionPlusArtifact);
                writer.write("'>download</a></p><div id='");
                writer.write("test");
                writer.write("' style='margin:8px 0px 0px 0px;padding:0px'>");
                for (int i = 0; i < content.length(); i += 300) {
                    StringEscapeUtils.escapeHtml((Writer)writer, (String)content.substring(i, Math.min(i + 300, content.length())));
                    writer.write(HTML_NEW_LINE);
                }
                writer.write("</div>");
                writer.write("</div>");
            }
        } else if ("artifact".equals(field)) {
            result = Searcher.writeFileContentResultToHTML(indentation, result, writer);
        } else {
            Searcher.writeResultIcon(writer, result);
            Searcher.writeResultName(result, writer);
        }
        Searcher.endIndentation(writer);
        for (Result actualResult : result.getContents().values()) {
            this.writeToHTML(indentation, actualResult, writer);
        }
    }

    @Override
    public Entry<String, Item>[] getAll() {
        System.out.println("getAll");
        return null;
    }

    @Override
    public String post(String key, Item item) {
        System.out.println("post");
        return null;
    }

    @Override
    public void put(String key, Item item) throws NotFoundException {
        System.out.println("put");
    }

    @Override
    public Entry<String, Item>[] query(String queryString) {
        try {
            String key;
            Item item;
            if (queryString.startsWith("highlight")) {
                int lastSemicolonIndex = queryString.lastIndexOf(";");
                String artifact = queryString.substring(lastSemicolonIndex + 1);
                int secondLastSemicolonIndex = queryString.lastIndexOf(";", lastSemicolonIndex - 1);
                String contribution = queryString.substring(secondLastSemicolonIndex + 1, lastSemicolonIndex);
                String query = queryString.substring("highlight".length(), secondLastSemicolonIndex);
                item = this.highlightArtifact(contribution, artifact, query);
                key = queryString.substring("highlight".length());
            } else if (queryString.startsWith("query")) {
                key = queryString.substring("query".length());
                item = this.executeQuery(key);
            } else {
                throw new NotFoundException("Invalid operation!");
            }
            Entry[] returnArray = new Entry[]{new Entry<String, Item>(key, item)};
            return returnArray;
        }
        catch (Exception t) {
            return new Entry[0];
        }
    }
}

