/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.launcher;

import org.apache.tuscany.sca.domain.manager.impl.DomainManagerConfiguration;
import org.apache.tuscany.sca.node.SCAClient;
import org.apache.tuscany.sca.node.SCANode;
import org.apache.tuscany.sca.node.SCANodeFactory;

public class DomainManagerLauncherBootstrap {
    private SCANode node;

    public DomainManagerLauncherBootstrap(String rootDirectory) throws Exception {
        this.node = new NodeFacade(rootDirectory);
    }

    public SCANode getNode() {
        return this.node;
    }

    public static class NodeFacade
    implements SCANode {
        private ClassLoader threadContextClassLoader;
        private ClassLoader runtimeClassLoader;
        private SCANode node;
        private String rootDirectory;

        private NodeFacade(String rootDirectory) {
            this.rootDirectory = rootDirectory;
            this.runtimeClassLoader = Thread.currentThread().getContextClassLoader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            this.threadContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.runtimeClassLoader);
                SCANodeFactory factory = SCANodeFactory.newInstance();
                this.node = factory.createSCANodeFromClassLoader("DomainManager.composite", this.getClass().getClassLoader());
                this.node.start();
                DomainManagerConfiguration domainManagerConfiguration = ((SCAClient)((Object)this.node)).getService(DomainManagerConfiguration.class, "DomainManagerConfigurationComponent");
                domainManagerConfiguration.setRootDirectory(this.rootDirectory);
            }
            finally {
                Thread.currentThread().setContextClassLoader(this.threadContextClassLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                Thread.currentThread().setContextClassLoader(this.runtimeClassLoader);
                this.node.stop();
            }
            finally {
                Thread.currentThread().setContextClassLoader(this.threadContextClassLoader);
            }
        }
    }
}

