/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search;

import java.util.HashMap;
import org.apache.tuscany.sca.domain.search.DocumentMap;
import org.apache.tuscany.sca.domain.search.DocumentProcessor;
import org.apache.tuscany.sca.domain.search.impl.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentProcessorsMap
extends HashMap<Class<?>, DocumentProcessor>
implements DocumentProcessor {
    private static final long serialVersionUID = 3967390896890947159L;

    private DocumentProcessor findDocumentProcessor(Object object, Class<?> clazz) {
        DocumentProcessor processor = (DocumentProcessor)this.get(clazz);
        if (processor == null) {
            Class<?>[] interfaces;
            for (Class<?> interfac : interfaces = clazz.getInterfaces()) {
                processor = this.findDocumentProcessor(object, interfac);
                if (processor == null) continue;
                return processor;
            }
            if (!clazz.isInterface()) {
                return this.findDocumentProcessor(object, clazz.getSuperclass());
            }
        }
        return processor;
    }

    @Override
    public Document process(DocumentProcessor parentProcessor, DocumentMap documents, Object object, Document document, String parent) {
        DocumentProcessor processor = this.findDocumentProcessor(object, object.getClass());
        if (processor == null) {
            throw new IllegalArgumentException();
        }
        if (document == null && (document = documents.get(processor.getDocumentKey(object))) == null) {
            document = FAKE_DOCUMENT;
        }
        processor.process(parentProcessor, documents, object, document, parent);
        return document;
    }

    @Override
    public Object getDocumentKey(Object object) {
        DocumentProcessor processor = this.findDocumentProcessor(object, object.getClass());
        if (processor != null) {
            return processor.getDocumentKey(object);
        }
        return null;
    }
}

