/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.io.IOException;
import java.net.URL;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.domain.search.DocumentMap;
import org.apache.tuscany.sca.domain.search.DocumentProcessor;
import org.apache.tuscany.sca.domain.search.impl.Document;
import org.apache.tuscany.sca.domain.search.impl.WrappedFileContent;

public class ArtifactDocumentProcessor
implements DocumentProcessor {
    public Document process(DocumentProcessor parentProcessor, DocumentMap documents, Object object, Document document, String parent) {
        if (object instanceof Artifact) {
            Artifact artifact = (Artifact)object;
            if (!(object instanceof Contribution)) {
                String location = artifact.getLocation();
                try {
                    if (document == null) {
                        document = documents.get("artifact" + location);
                    }
                    WrappedFileContent fileContent = new WrappedFileContent(new URL(location));
                    document.add((Fieldable)new Field("artifact", fileContent.getName(), Field.Store.YES, Field.Index.ANALYZED));
                    parent = parent + "\u0002artifact\u0003" + location + '\u0004' + fileContent.getName();
                    Document fileDoc = parentProcessor.process(parentProcessor, documents, fileContent, null, parent);
                    fileDoc.add((Fieldable)new Field("parent", parent, Field.Store.YES, Field.Index.ANALYZED));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return document == null ? FAKE_DOCUMENT : document;
        }
        throw new IllegalArgumentException();
    }

    public Object getDocumentKey(Object obj) {
        if (obj instanceof Artifact) {
            Artifact artifact = (Artifact)obj;
            String uri = artifact.getLocation();
            if (uri != null && uri.length() == 0) {
                return null;
            }
            return "artifact" + uri;
        }
        throw new IllegalArgumentException();
    }
}

