/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.domain.search.DocumentMap;
import org.apache.tuscany.sca.domain.search.DocumentProcessor;
import org.apache.tuscany.sca.domain.search.Result;
import org.apache.tuscany.sca.domain.search.impl.Document;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;

public class ComponentDocumentProcessor
implements DocumentProcessor {
    public Document process(DocumentProcessor parentProcessor, DocumentMap documents, Object object, Document doc, String parent) {
        if (object instanceof Component) {
            Component component = (Component)object;
            String uri = component.getURI();
            String name = component.getName();
            if ((uri = (uri == null ? "" : uri) + (name == null ? "" : name)).length() == 0) {
                uri = null;
            }
            if (uri != null) {
                InterfaceContract interfaceContract;
                if (doc == null) {
                    doc = documents.get(uri);
                }
                parent = parent + "\u0002component\u0003" + uri + '\u0004' + component.getName();
                doc.add((Fieldable)new Field("component", uri, Field.Store.YES, Field.Index.ANALYZED));
                for (ComponentService service : component.getServices()) {
                    Document serviceDoc = documents.get(uri + ':' + service.getName());
                    serviceDoc.add((Fieldable)new Field("servicename", service.getName(), Field.Store.YES, Field.Index.ANALYZED));
                    interfaceContract = service.getInterfaceContract();
                    if (interfaceContract != null) {
                        for (Operation operation : interfaceContract.getInterface().getOperations()) {
                            serviceDoc.add((Fieldable)new Field("serviceinterface", operation.getName(), Field.Store.YES, Field.Index.ANALYZED));
                        }
                        if (interfaceContract.getCallbackInterface() != null) {
                            for (Operation operation : interfaceContract.getCallbackInterface().getOperations()) {
                                serviceDoc.add((Fieldable)new Field("serviceinterfacecallback", operation.getName(), Field.Store.YES, Field.Index.ANALYZED));
                            }
                        }
                    }
                    serviceDoc.add((Fieldable)new Field("parent", parent, Field.Store.YES, Field.Index.ANALYZED));
                }
                for (ComponentReference reference : component.getReferences()) {
                    Document referenceDoc = documents.get(uri + ':' + reference.getName());
                    referenceDoc.add((Fieldable)new Field("referencename", reference.getName(), Field.Store.YES, Field.Index.ANALYZED));
                    interfaceContract = reference.getInterfaceContract();
                    if (interfaceContract != null) {
                        for (Operation operation : interfaceContract.getInterface().getOperations()) {
                            referenceDoc.add((Fieldable)new Field("referenceinterface", operation.getName(), Field.Store.YES, Field.Index.ANALYZED));
                        }
                        if (interfaceContract.getCallbackInterface() != null) {
                            for (Operation operation : interfaceContract.getCallbackInterface().getOperations()) {
                                referenceDoc.add((Fieldable)new Field("referenceinterfacecallback", operation.getName(), Field.Store.YES, Field.Index.ANALYZED));
                            }
                        }
                    }
                    referenceDoc.add((Fieldable)new Field("parent", parent, Field.Store.YES, Field.Index.ANALYZED));
                }
            }
            Document implementationDoc = parentProcessor.process(parentProcessor, documents, component.getImplementation(), null, parent);
            if (uri != null && implementationDoc != null) {
                implementationDoc.add((Fieldable)new Field("parent", uri, Field.Store.YES, Field.Index.ANALYZED));
            }
            for (ComponentProperty componentProperty : component.getProperties()) {
                Property property = componentProperty.getProperty();
                if (property == null) continue;
                Document propertyDoc = parentProcessor.process(parentProcessor, documents, property, null, parent);
                if (uri == null) continue;
                propertyDoc.add((Fieldable)new Field("parent", parent, Field.Store.YES, Field.Index.ANALYZED));
            }
            return doc == null ? FAKE_DOCUMENT : doc;
        }
        throw new IllegalArgumentException();
    }

    public Object getDocumentKey(Object obj) {
        if (obj instanceof Component) {
            Component component = (Component)obj;
            String uri = component.getURI();
            String name = component.getName();
            if ((uri = (uri == null ? "" : uri) + (name == null ? "" : name)).length() == 0) {
                return null;
            }
            return uri;
        }
        throw new IllegalArgumentException();
    }

    public Result processDocument(org.apache.lucene.document.Document document, Result result) {
        String componentName = document.get("component");
        if (componentName != null) {
            // empty if block
        }
        return null;
    }
}

