/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.domain.search.DocumentMap;
import org.apache.tuscany.sca.domain.search.DocumentProcessor;
import org.apache.tuscany.sca.domain.search.impl.Document;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;

public class ComponentTypeDocumentProcessor
implements DocumentProcessor {
    public Document process(DocumentProcessor parentProcessor, DocumentMap documents, Object object, Document doc, String parent) {
        if (object instanceof ComponentType) {
            ComponentType componentType = (ComponentType)object;
            String uri = componentType.getURI();
            if (uri != null && uri.length() == 0) {
                uri = null;
            }
            if (doc == null) {
                doc = uri != null ? documents.get(uri) : FAKE_DOCUMENT;
            }
            if (uri != null) {
                InterfaceContract interfaceContract;
                parent = parent + "\u0002componenttype\u0003" + uri;
                doc.add((Fieldable)new Field("componenttype", uri, Field.Store.YES, Field.Index.ANALYZED));
                for (Service service : componentType.getServices()) {
                    Document serviceDoc = documents.get(uri + ':' + service.getName());
                    serviceDoc.add((Fieldable)new Field("servicename", service.getName(), Field.Store.YES, Field.Index.ANALYZED));
                    interfaceContract = service.getInterfaceContract();
                    if (interfaceContract != null) {
                        Interface interfac = interfaceContract.getInterface();
                        if (interfac != null) {
                            for (Operation operation : interfac.getOperations()) {
                                serviceDoc.add((Fieldable)new Field("serviceinterface", operation.getName(), Field.Store.YES, Field.Index.ANALYZED));
                            }
                        }
                        if ((interfac = interfaceContract.getCallbackInterface()) != null) {
                            for (Operation operation : interfac.getOperations()) {
                                serviceDoc.add((Fieldable)new Field("serviceinterfacecallback", operation.getName(), Field.Store.YES, Field.Index.ANALYZED));
                            }
                        }
                    }
                    serviceDoc.add((Fieldable)new Field("parent", parent, Field.Store.YES, Field.Index.ANALYZED));
                }
                for (Reference reference : componentType.getReferences()) {
                    Document referenceDoc = documents.get(componentType.getURI() + ':' + reference.getName());
                    referenceDoc.add((Fieldable)new Field("referencename", reference.getName(), Field.Store.YES, Field.Index.ANALYZED));
                    interfaceContract = reference.getInterfaceContract();
                    if (interfaceContract != null) {
                        for (Operation operation : interfaceContract.getInterface().getOperations()) {
                            referenceDoc.add((Fieldable)new Field("referenceinterface", operation.getName(), Field.Store.YES, Field.Index.ANALYZED));
                        }
                        if (interfaceContract.getCallbackInterface() != null) {
                            for (Operation operation : interfaceContract.getCallbackInterface().getOperations()) {
                                referenceDoc.add((Fieldable)new Field("referenceinterfacecallback", operation.getName(), Field.Store.YES, Field.Index.ANALYZED));
                            }
                        }
                    }
                    referenceDoc.add((Fieldable)new Field("parent", parent, Field.Store.YES, Field.Index.ANALYZED));
                }
            }
            for (Property property : componentType.getProperties()) {
                Document propertyDoc = parentProcessor.process(parentProcessor, documents, property, null, parent);
                if (uri == null) continue;
                propertyDoc.add((Fieldable)new Field("parent", parent, Field.Store.YES, Field.Index.ANALYZED));
            }
            return doc;
        }
        throw new IllegalArgumentException();
    }

    public Object getDocumentKey(Object object) {
        if (object instanceof ComponentType) {
            ComponentType componentType = (ComponentType)object;
            String uri = componentType.getURI();
            if (uri == null || uri.length() == 0) {
                return null;
            }
            return uri;
        }
        throw new IllegalArgumentException();
    }
}

