/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.domain.search.DocumentMap;
import org.apache.tuscany.sca.domain.search.DocumentProcessor;
import org.apache.tuscany.sca.domain.search.impl.Document;

public class ContributionDocumentProcessor
implements DocumentProcessor {
    public Document process(DocumentProcessor parentProcessor, DocumentMap documents, Object object, Document doc, String parent) {
        if (object instanceof Contribution) {
            Contribution contribution = (Contribution)object;
            String uri = contribution.getURI();
            if (uri != null) {
                if (uri.length() == 0) {
                    uri = null;
                } else {
                    parent = parent + Character.toString('\u0001') + "contribution" + '\u0003' + uri;
                }
            }
            if (uri != null) {
                if (doc == null) {
                    doc = documents.get(uri);
                }
                doc.add((Fieldable)new Field("contribution", uri, Field.Store.YES, Field.Index.ANALYZED));
            } else {
                doc = FAKE_DOCUMENT;
            }
            for (Artifact artifact : contribution.getArtifacts()) {
                Document artifactDoc = parentProcessor.process(parentProcessor, documents, artifact, null, parent);
                if (uri == null) continue;
                artifactDoc.add((Fieldable)new Field("parent", parent, Field.Store.YES, Field.Index.ANALYZED));
            }
            if (!object.getClass().getSimpleName().contains("Workspace")) {
                for (Composite composite : contribution.getDeployables()) {
                    Document compositeDoc = parentProcessor.process(parentProcessor, documents, composite, null, parent);
                    if (uri == null) continue;
                    compositeDoc.add((Fieldable)new Field("parent", parent, Field.Store.YES, Field.Index.ANALYZED));
                }
            }
            return doc;
        }
        throw new IllegalArgumentException();
    }

    public Object getDocumentKey(Object object) {
        if (object instanceof Contribution) {
            Contribution contribution = (Contribution)object;
            String uri = contribution.getURI();
            if (uri != null && uri.length() == 0) {
                return null;
            }
            return uri;
        }
        throw new IllegalArgumentException();
    }
}

