/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tuscany.sca.domain.search.DocumentMap;
import org.apache.tuscany.sca.domain.search.DocumentProcessor;
import org.apache.tuscany.sca.domain.search.impl.Document;
import org.apache.tuscany.sca.domain.search.impl.FileContent;

public class DefaultFileDocumentProcessor
implements DocumentProcessor {
    public Document process(DocumentProcessor parentProcessor, DocumentMap documents, Object object, Document doc, String parent) {
        if (object instanceof FileContent) {
            FileContent file = (FileContent)object;
            try {
                InputStreamReader reader = new InputStreamReader(file.getInputStream());
                if (doc == null) {
                    doc = documents.get(file.getPath());
                }
                doc.add((Fieldable)new Field("filecontent", (Reader)reader));
                doc.add((Fieldable)new Field("filecontent", "", Field.Store.YES, Field.Index.ANALYZED));
                return doc;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    public Object getDocumentKey(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            String path = file.getPath();
            if (path != null && path.length() == 0) {
                return null;
            }
            return path;
        }
        throw new IllegalArgumentException();
    }
}

